/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2761")
public class RepeatedComplementOperatorCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Use the \"%s\" operator just once or not at all.";
    private static final String ADDITIONAL_CAST_MESSAGE = " If a type cast is intended, use \"%s\" instead.";
    private static final Tree.Kind[] COMPLEMENT_UNARY = new Tree.Kind[]{Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.UNARY_MINUS};
    private static final Tree.Kind[] CAST_UNARY = new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.UNARY_MINUS};
    private static final Map<Tree.Kind, String> CAST_FUNCTION = RepeatedComplementOperatorCheck.castFunctions();

    public static Map<Tree.Kind, String> castFunctions() {
        HashMap<Tree.Kind, String> map = new HashMap<Tree.Kind, String>();
        map.put(Tree.Kind.LOGICAL_COMPLEMENT, "(bool)");
        map.put(Tree.Kind.UNARY_MINUS, "(int)");
        return map;
    }

    @Override
    public void visitPrefixExpression(UnaryExpressionTree tree) {
        if (tree.is(COMPLEMENT_UNARY)) {
            this.checkRepeatedComplement(tree);
        }
        super.visitPrefixExpression(tree);
    }

    private void checkRepeatedComplement(UnaryExpressionTree tree) {
        if (CheckUtils.skipParenthesis(tree.expression()).is(tree.getKind())) {
            Object message = String.format(MESSAGE, tree.operator().text());
            if (tree.is(CAST_UNARY)) {
                message = (String)message + String.format(ADDITIONAL_CAST_MESSAGE, CAST_FUNCTION.get(tree.getKind()));
            }
            this.context().newIssue(this, tree, (String)message);
        }
    }
}

