/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1820")
public class TooManyFieldsInClassCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1820";
    private static final String MESSAGE = "Refactor this class so it has no more than %s%s fields, rather than the %s it currently has.";
    public static final int DEFAULT_MAX = 20;
    public static final boolean DEFAULT_COUNT_NON_PUBLIC = true;
    @RuleProperty(key="maximumFieldThreshold", defaultValue="20")
    public int maximumFieldThreshold = 20;
    @RuleProperty(key="countNonpublicFields", defaultValue="true", type="BOOLEAN")
    public boolean countNonpublicFields = true;

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        if (tree.is(Tree.Kind.CLASS_DECLARATION)) {
            this.visitClass(tree);
        }
    }

    private void visitClass(ClassTree tree) {
        int numberOfConstructorProperties;
        int numberOfFields = this.getNumberOfFields(tree);
        int allFields = numberOfFields + (numberOfConstructorProperties = this.getNumberOfConstructorProperties(tree));
        if (allFields > this.maximumFieldThreshold) {
            String message = String.format(MESSAGE, this.maximumFieldThreshold, this.countNonpublicFields ? "" : " public", allFields);
            this.context().newIssue(this, tree.classToken(), message);
        }
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.visitClass(tree);
    }

    private int getNumberOfFields(ClassTree tree) {
        List<ClassPropertyDeclarationTree> fields = TooManyFieldsInClassCheck.getClassFields(tree);
        int nbFields = fields.size();
        if (!this.countNonpublicFields) {
            nbFields -= TooManyFieldsInClassCheck.getNumberOfNonPublicFields(fields);
        }
        return nbFields;
    }

    private static List<ClassPropertyDeclarationTree> getClassFields(ClassTree classDeclaration) {
        ArrayList<ClassPropertyDeclarationTree> fields = new ArrayList<ClassPropertyDeclarationTree>();
        for (ClassMemberTree classMember : classDeclaration.members()) {
            if (!classMember.is(Tree.Kind.CLASS_PROPERTY_DECLARATION)) continue;
            fields.add((ClassPropertyDeclarationTree)classMember);
        }
        return fields;
    }

    private static int getNumberOfNonPublicFields(List<ClassPropertyDeclarationTree> fields) {
        int nbNonPublicFields = 0;
        for (ClassPropertyDeclarationTree field : fields) {
            if (!field.is(Tree.Kind.CLASS_PROPERTY_DECLARATION) || !TooManyFieldsInClassCheck.isNonPublic(field.modifierTokens())) continue;
            ++nbNonPublicFields;
        }
        return nbNonPublicFields;
    }

    private static boolean isNonPublic(List<SyntaxToken> modifiers) {
        for (SyntaxToken modifierToken : modifiers) {
            String modifier = modifierToken.text();
            if (PHPKeyword.VAR.getValue().equals(modifier) || !PHPKeyword.PROTECTED.getValue().equals(modifier) && !PHPKeyword.PRIVATE.getValue().equals(modifier)) continue;
            return true;
        }
        return false;
    }

    private int getNumberOfConstructorProperties(ClassTree tree) {
        Stream<MethodDeclarationTree> constructors = TooManyFieldsInClassCheck.getConstructors(tree);
        return (int)constructors.map(constructor -> constructor.parameters().parameters()).flatMap(Collection::stream).filter(ParameterTree::isPropertyPromotion).filter(parameter -> {
            if (!this.countNonpublicFields) {
                return "public".equalsIgnoreCase(parameter.visibility().text());
            }
            return true;
        }).count();
    }

    private static Stream<MethodDeclarationTree> getConstructors(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(Tree.Kind.METHOD_DECLARATION)).map(MethodDeclarationTree.class::cast).filter(member -> "__construct".equals(member.name().text()));
    }
}

