/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S6343")
public class WordPressAutoUpdateCheck
extends WordPressConfigVisitor {
    private static final String MESSAGE = "Make sure deactivating automatic updates is intended.";

    @Override
    protected Set<String> configsToVisit() {
        return new HashSet<String>(Arrays.asList("AUTOMATIC_UPDATER_DISABLED", "WP_AUTO_UPDATE_CORE", "DISALLOW_FILE_MODS"));
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        this.configKeyString(config).ifPresent(key -> {
            if ("WP_AUTO_UPDATE_CORE".equals(key)) {
                this.raiseOnMatchingValue(config, CheckUtils::isFalseValue);
            } else {
                this.raiseOnMatchingValue(config, CheckUtils::isTrueValue);
            }
        });
    }

    private void raiseOnMatchingValue(FunctionCallTree config, Predicate<ExpressionTree> valuePredicate) {
        WordPressAutoUpdateCheck.configValue(config).filter(valuePredicate).ifPresent(v -> this.newIssue(config, MESSAGE));
    }
}

