/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.symbols;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;

public class Parameter {
    private final String name;
    private final String type;
    private final boolean hasDefault;
    private final boolean hasEllipsisOperator;

    public Parameter(String name, @Nullable String type, boolean hasDefault, boolean hasEllipsisOperator) {
        this.type = type;
        this.name = name;
        this.hasDefault = hasDefault;
        this.hasEllipsisOperator = hasEllipsisOperator;
    }

    public static Parameter fromTree(ParameterTree parameter) {
        String parameterName = parameter.variableIdentifier().text();
        String parameterType = parameter.declaredType() != null ? parameter.declaredType().toString() : null;
        return new Parameter(parameterName, parameterType, parameter.initValue() != null, parameter.ellipsisToken() != null);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public boolean hasEllipsisOperator() {
        return this.hasEllipsisOperator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)other;
        return this.hasDefault == parameter.hasDefault && this.hasEllipsisOperator == parameter.hasEllipsisOperator && Objects.equals(this.name, parameter.name) && Objects.equals(this.type, parameter.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.hasDefault, this.hasEllipsisOperator);
    }
}

