/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.lexical;

import com.sonar.sslr.api.TokenType;
import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.Patterns;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class InternalSyntaxToken
extends PHPTree
implements SyntaxToken {
    private final Tree.Kind kind;
    private final List<SyntaxTrivia> trivias;
    private final int startIndex;
    private final int line;
    private final int column;
    private final String value;
    private final boolean isEOF;
    private int endLine;
    private int endColumn;

    public InternalSyntaxToken(int line, int column, String value, List<SyntaxTrivia> trivias, int startIndex, boolean isEOF) {
        this.value = value;
        this.line = line;
        this.column = column;
        this.trivias = trivias;
        this.startIndex = startIndex;
        this.isEOF = isEOF;
        this.kind = InternalSyntaxToken.isInlineHTML(value) ? Tree.Kind.INLINE_HTML_TOKEN : Tree.Kind.TOKEN;
        this.calculateEndOffsets();
    }

    private void calculateEndOffsets() {
        String[] lines = Patterns.LINEBREAK_PATTERN.split(this.value, -1);
        this.endColumn = this.column + this.value.length();
        this.endLine = this.line + lines.length - 1;
        if (this.endLine != this.line) {
            this.endColumn = lines[lines.length - 1].length();
        }
    }

    private static boolean isInlineHTML(String value) {
        return value.startsWith("?>") || value.startsWith("%>");
    }

    public int toIndex() {
        return this.startIndex + this.value.length();
    }

    @Override
    public String text() {
        return this.value;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return this.trivias;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    public int startIndex() {
        return this.startIndex;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    public boolean is(TokenType type) {
        return this.text().equals(type.getValue());
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(this.trivias().iterator());
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitToken(this);
    }

    @Override
    public SyntaxToken getFirstToken() {
        return this;
    }

    @Override
    public SyntaxToken getLastToken() {
        return this;
    }
}

