/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

public class EmptyStringRepetitionFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Rework this part of the regex to not match the empty string.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public EmptyStringRepetitionFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        RegexTree element = tree.getElement();
        if (this.matchEmptyString(element)) {
            this.regexElementIssueReporter.report(element, MESSAGE, null, Collections.emptyList());
        }
    }

    private boolean matchEmptyString(RegexTree element) {
        switch (element.kind()) {
            case SEQUENCE: {
                return ((SequenceTree)element).getItems().stream().allMatch(this::matchEmptyString);
            }
            case DISJUNCTION: {
                return ((DisjunctionTree)element).getAlternatives().stream().anyMatch(this::matchEmptyString);
            }
            case REPETITION: {
                return ((RepetitionTree)element).getQuantifier().getMinimumRepetitions() == 0;
            }
            case LOOK_AROUND: 
            case BOUNDARY: {
                return true;
            }
        }
        if (element instanceof GroupTree) {
            RegexTree nestedElement = ((GroupTree)element).getElement();
            return nestedElement == null || this.matchEmptyString(nestedElement);
        }
        return false;
    }
}

