/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.accounts;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ReplacingExternalCredentialsProvider
implements IExternalCredentialsProvider {
    private final IExternalCredentialsProvider underlyingExternalCredentialsProvider;
    private final String credentialsName;
    private final ExternalCredentials externalCredentialsReplacement;

    public ReplacingExternalCredentialsProvider(IExternalCredentialsProvider underlyingExternalCredentialsProvider, String credentialsName, ExternalCredentials externalCredentialsReplacement) {
        this.underlyingExternalCredentialsProvider = underlyingExternalCredentialsProvider;
        this.credentialsName = credentialsName;
        this.externalCredentialsReplacement = externalCredentialsReplacement;
        CCSMAssert.isNotNull((Object)credentialsName);
        CCSMAssert.isTrue((this.externalCredentialsReplacement == null || credentialsName.equals(externalCredentialsReplacement.credentialsName) ? 1 : 0) != 0, (String)"Replacement must be null or the account names must be equal.");
    }

    public ExternalCredentials getExternalCredentials(String credentialsName) throws StorageException {
        ExternalCredentials storedCredentials = this.underlyingExternalCredentialsProvider.getExternalCredentials(credentialsName);
        if (Objects.equals(this.credentialsName, credentialsName)) {
            if ("_#_mskd_#_".equals(this.externalCredentialsReplacement.password) && storedCredentials != null) {
                return new ExternalCredentials(this.externalCredentialsReplacement.credentialsName, this.externalCredentialsReplacement.uri, this.externalCredentialsReplacement.username, storedCredentials.password, this.externalCredentialsReplacement.connectorTypeInfo);
            }
            return this.externalCredentialsReplacement;
        }
        return storedCredentials;
    }
}

