/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.compaction;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;

public class ProjectDatabaseCleanupTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException, ExecutionCanceledException {
        InternalProjectId projectId = this.jobDescriptor.getInternalProjectId();
        IStorageSystem storageSystem = this.indexLayer.openRawProjectStorageSystem(projectId);
        MetaIndex metaIndex = this.indexLayer.openMetaIndex((IProjectId)projectId);
        IndexSchema indexSchema = (IndexSchema)metaIndex.getValue(IndexSchema.class);
        for (String storeName : indexSchema.getEntryNames()) {
            this.verifyNotCanceled();
            SchemaEntry schemaEntry = indexSchema.getEntry(storeName);
            if (!schemaEntry.usesOption(EStorageOption.BRANCHED)) continue;
            IBranchingLayer branchingLayer = indexSchema.openBranchingLayer(schemaEntry.createIndexClass(), storeName, storageSystem);
            long deletedEntries = branchingLayer.removeOrphanedDataEntries((ICancelable)this);
            LOGGER.info("Removed " + deletedEntries + " data entries from the " + schemaEntry.getIndexClass() + " store.");
        }
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PRIORITY_FULLY_ISOLATED;
    }
}

