/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/sap-connection-identifiers")
public class SapConnectionService
extends ApiBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    @Operation(summary="Get all existing SAP connection identifiers.", description="Returns all SAP connection identifiers configured in the instance.", tags={"SAP", "System"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    public List<String> getAllSapSystemConnectionIdentifiers() throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.getIndexLayer().openGlobalIndex(ServerOptionIndex.class);
        return CollectionUtils.map(AbapSystemDescription.getAllInstances((ServerOptionIndex)serverOptionIndex).keySet(), sapConnectionDescriptor -> StringUtils.getLastPart((String)sapConnectionDescriptor, (char)'/'));
    }
}

