/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.sap.abapsystem.AbapRepositoryUtil;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.rfc.SapSystemCommunicationException;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/sap-history-id-lock")
public class SapHistoryIdLockService
extends ApiBase {
    @DELETE
    @Path(value="{sapConfigurationId}")
    @Operation(summary="Clear history ID", description="Clears the history ID lock flag for the given SAP configuration. The lock flag is set in table /CQSE/ABAPEXP in the SAP system when a Teamscale export is active as only one instance of Teamscale should access the same history. In rare cases, e.g. the export job did not finish properly, the lock flag remains set. This prevents further fetching of ABAP changes. In this case, this service can be called to reset the flag.", tags={"SAP"}, responses={@ApiResponse(responseCode="404", description="No SAP connection configuration found for given ID.")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void clearHistoryIdLock(@Parameter(description="Identifier of the SAP connection configuration in the Admin perspective.", required=true) @PathParam(value="sapConfigurationId") String sapConfigurationId) throws StorageException, SapSystemCommunicationException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        AbapSystemDescription abapSystemDescription = AbapSystemDescription.getInstanceFromOptionIndex((String)sapConfigurationId, (ServerOptionIndex)serverOptionIndex);
        if (abapSystemDescription == null) {
            throw new NotFoundException("No SAP connection configuration found for ID '" + sapConfigurationId + "'.");
        }
        int returnCode = AbapRepositoryUtil.clearAbapHistoryIdLock((String)sapConfigurationId, (ServerOptionIndex)serverOptionIndex, (AbapSystemDescription)abapSystemDescription);
        if (returnCode != AbapRepositoryUtil.CLEAR_LOCK_SUCCESS_RETURN_CODE) {
            throw new InternalServerErrorException("Could not clear lock flag, sy-subrc of UPDATE was " + returnCode + ".");
        }
    }
}

