/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PathRegexGenerator {
    public static Set<String> makeRegexFromPaths(Set<String> pathsToMatch, Set<String> allPaths) {
        TreeSet<String> regexPaths = new TreeSet<String>(pathsToMatch);
        PriorityQueue<String> uncheckedPaths = new PriorityQueue<String>((Collection<String>)regexPaths);
        TreeSet<String> allProjectPaths = new TreeSet<String>(allPaths);
        while (!uncheckedPaths.isEmpty()) {
            File pathToCheck = new File(uncheckedPaths.poll()).getParentFile();
            PathRegexGenerator.makeRegexFromPath(pathToCheck, regexPaths, uncheckedPaths, allProjectPaths);
        }
        return regexPaths;
    }

    private static void makeRegexFromPath(File pathToCheck, Set<String> regexPaths, PriorityQueue<String> uncheckedPaths, Set<String> allProjectPaths) {
        boolean containsAll;
        Object prefixToCheck = pathToCheck.getPath().replace("\\", "/");
        if (!((String)prefixToCheck).isEmpty()) {
            prefixToCheck = (String)prefixToCheck + "/";
        }
        do {
            HashSet<String> toMatch;
            if (!(containsAll = PathRegexGenerator.checkContainsAll((String)prefixToCheck, regexPaths, allProjectPaths, toMatch = new HashSet<String>()))) continue;
            PathRegexGenerator.combinePathsInListsToRegex(toMatch, pathToCheck, regexPaths, allProjectPaths, uncheckedPaths);
            pathToCheck = pathToCheck.getParentFile();
            if (pathToCheck == null) continue;
            prefixToCheck = pathToCheck.getPath().replace("\\", "/");
        } while (containsAll && pathToCheck != null);
    }

    private static boolean checkContainsAll(String prefixToCheck, Set<String> regexPaths, Set<String> allPaths, Set<String> toMatch) {
        toMatch.addAll(regexPaths.stream().filter(s -> s.startsWith(prefixToCheck)).collect(Collectors.toSet()));
        Set all = allPaths.stream().filter(s -> s.startsWith(prefixToCheck)).collect(Collectors.toSet());
        return toMatch.containsAll(all) && toMatch.size() == all.size();
    }

    private static void combinePathsInListsToRegex(Set<String> toMatch, File pathToCheck, Set<String> regexPaths, Set<String> allPaths, PriorityQueue<String> uncheckedPaths) {
        Set<String> fileExtensionsToMatch = PathRegexGenerator.findFileExtensions(toMatch);
        for (String fileExtensionToMatch : fileExtensionsToMatch) {
            String regexPath = new File(pathToCheck, "**" + fileExtensionToMatch).getPath().replace("\\", "/");
            regexPaths.add(regexPath);
            allPaths.add(regexPath);
        }
        regexPaths.removeAll(toMatch);
        allPaths.removeAll(toMatch);
        uncheckedPaths.removeAll(toMatch);
    }

    private static Set<String> findFileExtensions(Set<String> filePaths) {
        return filePaths.stream().map(path -> path.substring(path.lastIndexOf("."))).collect(Collectors.toSet());
    }
}

