/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/synchronization/users")
public class SynchronizeUsersService
extends ApiBase {
    @POST
    @Operation(summary="Synchronize users", description="Synchronizes all users with a remote server. Returns the names of updated users.", responses={@ApiResponse(responseCode="404", description="The given server could not be found")}, tags={"Users"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS})
    public List<String> synchronizeAllUsers(@Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        try {
            return this.getSynchronizeUsersStrategy(serverName, serverType).synchronizeUsers();
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @Operation(summary="Synchronize user", description="Synchronizes the given user with a remote server.", responses={@ApiResponse(responseCode="404", description="The given server or group could not be found")}, tags={"Users"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS})
    @Path(value="{userName}")
    public void synchronizeUser(@Parameter(description="The name of the user that should be synchronized.") @PathParam(value="userName") String userName, @Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        User user = this.openGlobalIndex(UserIndex.class).getUser(userName);
        if (user == null) {
            throw new NotFoundException("User not found: " + userName);
        }
        try {
            this.getSynchronizeUsersStrategy(serverName, serverType).synchronizeUser(user);
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private ISynchronizeUsersStrategy getSynchronizeUsersStrategy(String serverName, EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
        return toolProvider.createSynchronizeUsersStrategy(serverName);
    }
}

