/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.core.options.DataPrivacyOption;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.permissions.PermissionFilterUtils;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;

public abstract class TimeRangeResourceServiceBase
extends ApiBase {
    protected static final int MINIMUM_REQUIRED_GROUP_SIZE = 3;

    protected TimeRange createTimeRange(TimeRangeResourceServiceQueryOptions parameters) throws StorageException {
        return parameters.resolve((IFactory<ProjectStorageSystem, StorageException>)((IFactory)this::getProjectStorageSystem));
    }

    protected Optional<UserGroup> getValidatedUserGroup(@Nullable String userGroupName) throws StorageException {
        if (userGroupName == null) {
            return Optional.empty();
        }
        UserGroup userGroup = this.openGlobalIndex(UserGroupIndex.class).getUserGroup(userGroupName);
        if (userGroup == null || !this.isUserVisibleGroup(userGroupName)) {
            throw new BadRequestException("The group '" + userGroupName + "' does not exist.");
        }
        if (DataPrivacyOption.getDataPrivacyOption((GlobalStorageSystem)this.getGlobalStorageSystem()).limitDevelopersLogToOwnCommits && userGroup.getUserNames().size() < 3 && !this.getPermissions().hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES)) {
            throw new BadRequestException("The group '" + userGroupName + "' has less than 3 users. This is not allowed due to the configured Data Privacy Settings.");
        }
        return Optional.of(userGroup);
    }

    private boolean isUserVisibleGroup(String userGroupName) throws StorageException {
        List<UserGroup> userVisibleGroups = PermissionFilterUtils.getVisibleGroups(this.getPermissions(), this.openGlobalIndex(UserGroupIndex.class));
        return userVisibleGroups.stream().anyMatch(groupName -> groupName.getName().equals(userGroupName));
    }
}

