/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.documentation.DocumentationBuilderException;
import com.teamscale.service.documentation.analysis_profile.AnalysisProfileDocumentationBuilder;
import com.teamscale.service.documentation.analysis_profile.ProfileDocumentation;
import com.teamscale.service.documentation.layout.Layouter;
import com.teamscale.service.documentation.layout.MarkdownLayout;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/analysis-profiles/{analysisProfileName}/documentation")
public class AnalysisProfileDocumentationService
extends ApiBase {
    @GET
    @Operation(summary="Get analysis profile documentation", description="Returns documentation of an analysis profile. The documentation is restricted to findings which are enabled in the profile and includes descriptions of the findings.")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    public Response downloadAnalysisProfileDocumentation(@PathParam(value="analysisProfileName") String analysisProfile) throws StorageException {
        AnalysisProfileDocumentationBuilder docBuilder;
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile profile = analysisProfileIndex.getProfile(analysisProfile);
        if (profile == null) {
            throw new NotFoundException("No such analysis profile: " + analysisProfile);
        }
        ConfigurationTemplate template = this.getTemplate(profile);
        Map<String, CheckInfo> checkInfoMap = AnalysisProfileDocumentationService.buildCheckInfoMap(profile);
        try {
            docBuilder = new AnalysisProfileDocumentationBuilder(profile, template, checkInfoMap);
        }
        catch (DocumentationBuilderException e) {
            throw new InternalServerErrorException("Error creating documentation for analysis profile '" + profile.getName() + "'.", (Throwable)e);
        }
        ProfileDocumentation analysisProfileDoc = docBuilder.getAnalysisProfileDoc();
        Layouter layouter = new Layouter(new MarkdownLayout());
        String analysisProfileDocumentation = analysisProfileDoc.layout(layouter);
        String fileName = profile.getName() + ".md";
        return ResponseUtils.getFileDownloadResponse((Object)StringUtils.stringToBytes((String)analysisProfileDocumentation), (MediaType)MoreMediaTypes.TEXT_MARKDOWN_TYPE, (String)fileName);
    }

    private ConfigurationTemplate getTemplate(AnalysisProfile profile) throws BadRequestException {
        ConfigurationTemplate template;
        try {
            template = ConfigRegistry.getInstance().createConfigurationTemplate((Set)profile.getLanguages(), (Set)profile.getTools(), this.getGlobalStorageSystem());
        }
        catch (ProjectConfigurationException e) {
            throw new BadRequestException("Unable to retrieve configuration template", (Throwable)e);
        }
        if (template == null) {
            throw new BadRequestException("Unable to retrieve configuration template, null returned.");
        }
        return template;
    }

    private static Map<String, CheckInfo> buildCheckInfoMap(AnalysisProfile profile) {
        List<CheckInfo> checkInfos = CheckRegistry.getInstance().getChecksInfos().stream().filter(checkInfo -> !Collections.disjoint(checkInfo.getSupportedLanguages(), profile.getLanguages())).toList();
        HashMap<String, CheckInfo> checkInfoMap = new HashMap<String, CheckInfo>();
        for (CheckInfo checkInfo2 : checkInfos) {
            checkInfoMap.put(checkInfo2.getId(), checkInfo2);
        }
        return checkInfoMap;
    }
}

