/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.report.generic.ExternalFindingFileData;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.external.input.SimpleExternalFindingImportService;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import com.teamscale.service.upload.base.LegacyExternalReportUploadServiceUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="p/{project}/add-external-findings")
public class LegacySimpleExternalFindingImportService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @PUT
    @Path(value="{sessionId}")
    @Operation(summary="Insert results into session", description="Adds results for one or more file to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis", "Findings"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Failed to parse provided report.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response insertAnalysisResults(@PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) List<ExternalFindingFileData> externalMetrics) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(SimpleExternalFindingImportService.class, (ResourceContext)this.resourceContext, resource -> resource.uploadExternalFindings(sessionId, parameters, externalMetrics), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyExternalReportUploadServiceUtils.notFoundToBadRequestUnlessUnknownSession(), LegacyExternalReportUploadServiceUtils.closedSessionToInternalServerError()});
    }

    @PUT
    @Operation(summary="Insert results into session", description="Adds results for one or more file to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis", "Findings"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Failed to parse provided report.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public Response insertAnalysisResults(@BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) List<ExternalFindingFileData> externalMetrics) throws StorageException {
        return this.insertAnalysisResults("auto-create", parameters, externalMetrics);
    }
}

