/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/global-indicators-and-groups")
public class GlobalIndicatorsAndGroupsService
extends ApiBase {
    @GET
    @Operation(summary="Get quality indicator and analysis group names", description="Retrieves the available quality indicator and analysis group names from all configured projects.", tags={"Analysis profiles"})
    @RequiresNoPermission(description="Every authenticated user should see the available quality indicator and analysis group names.")
    public IndicatorsAndGroups getGlobalIndicatorsAndGroups() throws StorageException, ProjectConfigurationException {
        HashSet<String> existingQualityIndicators = new HashSet<String>();
        HashSet<String> configuredAnalysisGroups = new HashSet<String>();
        ProjectIndex projectIndex = this.getIndexLayer().openProjectIndex();
        HashSet usedProfiles = new HashSet();
        for (InternalProjectId projectId : projectIndex.getAllInternalProjectIds()) {
            usedProfiles.addAll(ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)this.getIndexLayer()).getAnalysisProfileNames());
        }
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        List analysisProfiles = analysisProfileIndex.getProfiles(new ArrayList(usedProfiles), true);
        for (AnalysisProfile analysisProfile : analysisProfiles) {
            GlobalIndicatorsAndGroupsService.addIndicatorsAndGroups(existingQualityIndicators, configuredAnalysisGroups, analysisProfile, this.getGlobalStorageSystem());
        }
        return new IndicatorsAndGroups(existingQualityIndicators, configuredAnalysisGroups);
    }

    private static void addIndicatorsAndGroups(Set<String> qualityIndicators, Set<String> analysisGroups, AnalysisProfile profile, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate((Set)profile.getLanguages(), (Set)profile.getTools(), globalStorageSystem);
        AnalysisProfileUtils.initDefaultsFromProfile((ConfigurationTemplate)template, (AnalysisProfile)profile, (GlobalStorageSystem)globalStorageSystem);
        for (QualityIndicatorTemplate qualityIndicator : template.getQualityIndicators()) {
            boolean hasGroupWithFinding = false;
            for (String analysisGroupName : qualityIndicator.getGroupNames()) {
                if (!GlobalIndicatorsAndGroupsService.hasEnabledFinding(template.getAnalysisGroup(analysisGroupName))) continue;
                analysisGroups.add(analysisGroupName);
                hasGroupWithFinding = true;
            }
            if (!hasGroupWithFinding) continue;
            qualityIndicators.add(qualityIndicator.getName());
        }
    }

    private static boolean hasEnabledFinding(AnalysisGroupDescriptor group) {
        for (ConfigurationItemBase configItem : group.getConfigurationItems()) {
            if (!(configItem instanceof FindingDescriptor) || !((FindingDescriptor)configItem).getEnablement().isEnabled()) continue;
            return true;
        }
        return false;
    }

    public static class IndicatorsAndGroups {
        private static final String QUALITY_INDICATORS_PROPERTY = "qualityIndicators";
        private static final String ANALYSIS_GROUPS_PROPERTY = "analysisGroups";
        @JsonProperty(value="qualityIndicators")
        private final Set<String> qualityIndicators;
        @JsonProperty(value="analysisGroups")
        private final Set<String> analysisGroups;

        @JsonCreator
        public IndicatorsAndGroups(@JsonProperty(value="qualityIndicators") Set<String> qualityIndicators, @JsonProperty(value="analysisGroups") Set<String> analysisGroups) {
            this.qualityIndicators = qualityIndicators;
            this.analysisGroups = analysisGroups;
        }

        public Set<String> getQualityIndicators() {
            return this.qualityIndicators;
        }

        public Set<String> getAnalysisGroups() {
            return this.analysisGroups;
        }
    }
}

