/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.jira.JiraConnectorUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.FindingChurnListDto;
import com.teamscale.service.findings.FindingChurnTruncationParameter;
import com.teamscale.service.findings.IssueFindingChurnService;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.LegacyApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="p/{project}/issue-finding-churn")
public class LegacyIssueFindingChurnService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @Context
    private ResourceContext resourceContext;

    @GET
    @Operation(summary="Get issue finding churn", description="Determines an aggregated finding churn across all commits of the issue.", responses={@ApiResponse(responseCode="404", description="Issue could not be found"), @ApiResponse(responseCode="409", description="Multiple issues for the provided ID found")}, tags={"Issues", "Findings"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{issueId}")
    public FindingChurnListDto getIssueFindingChurn(@Parameter(description="ID of the issue to determine the finding churn for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId) throws StorageException {
        return ((IssueFindingChurnService)this.resourceContext.getResource(IssueFindingChurnService.class)).getIssueFindingChurn(issueId, JiraConnectorUtils.shouldHideResolveFindingsInBadges((ProjectStorageSystem)this.getProjectStorageSystem(), (Logger)LOGGER), false, new FindingChurnTruncationParameter());
    }
}

