/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.gadgets;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/gadgets/jira")
public class JiraGadgetService
extends ApiBase {
    @GET
    @Path(value="dashboard.xml")
    @RequiresNoLogin
    @Operation(summary="Get the dashboard gadget", description="Returns the XML descriptor for the dashboard gadget.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="400", description="Must configure base URL before calling this service.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_8_0)
    @Produces(value={"application/xml", "text/xml"})
    public byte[] getDashboardGadget() throws StorageException {
        String template = Resource.of(JiraGadgetService.class, (String)"jira-dashboard-gadget.xml").getContent();
        String baseUri = this.serviceInfo.getRequestBaseUri().toString();
        String result = template.replaceAll("BASE_URL", StringUtils.stripSuffix((String)baseUri, (String)"/"));
        return StringUtils.stringToBytes((String)result);
    }

    @GET
    @Path(value="dashboard-thumbnail.png")
    @RequiresNoLogin
    @Operation(summary="Get the thumbnail of the Jira dashboard gadget", description="Returns the thumbnail of the Jira dashboard gadget", tags={"Dashboards"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_8_0)
    @Produces(value={"image/png"})
    public byte[] getDashboardThumbnail() {
        return Resource.of(JiraGadgetService.class, (String)"jira-dashboard-thumbnail.png").getAsByteArray();
    }
}

