/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IGlobalLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/logs/worker")
public class WorkerLogGlobalLogService
extends ApiBase
implements IGlobalLogServiceApi<ShortWorkerLog, DetailedWorkerLog> {
    static final String WORKER_LOG_FILENAME = "TeamscaleWorkerLogExport";

    @Override
    @Operation(summary="Get all worker logs", description="Returns a list of all worker short logs.", tags={"Logging"}, operationId="getGlobalWorkerLogs")
    public ShortLogResponse<ShortWorkerLog> getAllShortLogs(LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, WorkerLogGlobalLogService.openWorkerLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Get worker detail log", description="Returns the detailed worker log entry for the given timestamp.", tags={"Logging"}, operationId="getGlobalWorkerLog")
    public DetailedWorkerLog getDetailedLog(LogEntryIdentifier logEntryIdentifier) throws StorageException {
        return (DetailedWorkerLog)LogServiceUtils.getDetailedLogEntry(WorkerLogGlobalLogService.openWorkerLogIndexes(this.getIndexLayer()), (LogEntryIdentifier)logEntryIdentifier);
    }

    @Override
    @Operation(summary="Get worker log frequencies", description="Returns the frequencies of the various worker log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getGlobalWorkerLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies() throws StorageException {
        return LogServiceUtils.obtainFrequencies(WorkerLogGlobalLogService.openWorkerLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Download worker logs", description="Returns a file download of all worker logs.", tags={"Logging"}, operationId="downloadGlobalWorkerLogs")
    public Response downloadLog(@BeanParam LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)WORKER_LOG_FILENAME, (LogFilteringParameters)logFilteringParameters, (int)maxChars, WorkerLogGlobalLogService.openWorkerLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Delete worker logs", description="Deletes all log entries that match the applied filters.", tags={"Logging"}, operationId="deleteGlobalWorkerLogs")
    public void deleteLogEntries(LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, WorkerLogGlobalLogService.openWorkerLogIndexes(this.getIndexLayer()));
        AuditLogs.globalLogDeletion((String)"worker logs");
    }

    public static LogIndexesWrapper<ShortWorkerLog, DetailedWorkerLog> openWorkerLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList allWorkerLogIndexes = LogServiceUtils.getAllWorkerLogIndexes((IndexLayer)indexLayer);
        Map digestIndexes = LogServiceUtils.getDigestIndexesForProjects((IndexLayer)indexLayer, (Collection)allWorkerLogIndexes.extractFirstList());
        return new LogIndexesWrapper(allWorkerLogIndexes, digestIndexes);
    }
}

