/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.export;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.metrics.assessment.GroupAssessment;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.assessment.MetricAssessmentService;
import com.teamscale.service.metrics.export.MetricAssessmentCsvConverter;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/export-metric-assessment")
public class MetricAssessmentExportService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Export metric assessment", description="Exports the metric assessment based on a threshold configuration as CSV")
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.class, SpecItemContributor.class})
    public Response exportMetricAssessmentAsCSV(@Parameter(description="Id of the metric threshold configuration.", required=true) @QueryParam(value="configuration-name") String thresholdConfigurationName, @Parameter(description="The timestamp used as baseline for trends. (No trend will be computed if this parameter is not specified.") @QueryParam(value="baseline") UnresolvedCommitDescriptor baseline, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Metric assessment name.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException, MetricThresholdConfigurationException {
        Optional<UnresolvedCommitDescriptor> parsedBaseline = Optional.ofNullable(baseline);
        List<GroupAssessment> assessmentResult = MetricAssessmentService.computeAssessmentResult(thresholdConfigurationName, (IStorageInfo)this.serviceInfo, uniformPath.toString(), this.determineHistoryOption(commit), this.getUser(), parsedBaseline, false, this.getParallelTaskExecutor());
        String csvFileName = "MetricsTable-" + thresholdConfigurationName;
        MetricAssessmentCsvConverter assessmentCsvConverter = new MetricAssessmentCsvConverter(assessmentResult);
        return CsvServiceUtils.createCsvResponse((String)csvFileName, assessmentCsvConverter::createCsvData);
    }
}

