/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import io.prometheus.metrics.core.metrics.CounterWithCallback;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public abstract class IndexCallbackMetricsProviderBase {
    protected final IndexLayer indexLayer;
    private static final Logger LOGGER = LogManager.getLogger();

    protected IndexCallbackMetricsProviderBase(IndexLayer indexLayer) {
        this.indexLayer = indexLayer;
    }

    protected static void collectMetricValueByTwoDimHashmap(CounterWithCallback.Callback cb, TwoDimHashMap<String, String, Double> values) {
        for (String firstKey : values.getFirstKeys()) {
            for (Map.Entry valueBySecondKey : values.getSecondMap((Object)firstKey).entrySet()) {
                cb.call(((Double)valueBySecondKey.getValue()).doubleValue(), new String[]{firstKey, (String)valueBySecondKey.getKey()});
            }
        }
    }

    protected static void wrapInStorageExceptionLogger(GaugeWithCallback.Callback callback, SupplierWithException<Double, StorageException> throwingAccessor) {
        try {
            callback.call(((Double)throwingAccessor.get()).doubleValue(), new String[0]);
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve metrics.", (Throwable)e);
        }
    }

    protected void doForAllProjects(BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException> consumer) {
        List allProjectInfos = null;
        try {
            ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
            allProjectInfos = projectIndex.getAllProjectInfos();
        }
        catch (StorageException storageException) {
            LOGGER.error("Could not retrieve list of projects to collect project metrics.", (Throwable)storageException);
        }
        if (allProjectInfos == null) {
            return;
        }
        for (ProjectInfo project : allProjectInfos) {
            CommitResolvingStorageSystem projectStorageSystem = null;
            try {
                projectStorageSystem = this.indexLayer.openProjectStorageSystem(project);
            }
            catch (StorageException e) {
                LOGGER.error("Could not resolve project storage system for project '{}'.", (Object)project.getPrimaryPublicId().toString(), (Object)e);
                continue;
            }
            try {
                consumer.accept((Object)project.getPrimaryPublicId(), (Object)projectStorageSystem);
            }
            catch (StorageException e) {
                LOGGER.error("Could not collect metrics for project '{}'", (Object)project.getPrimaryPublicId().toString(), (Object)e);
            }
        }
    }

    protected void doForAllConnectors(ConsumerWithException<ProjectConnectorCallbackInfo, StorageException> consumer) {
        this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> {
            ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem);
            for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
                consumer.accept((Object)new ProjectConnectorCallbackInfo((PublicProjectId)publicProjectId, (ProjectStorageSystem)projectStorageSystem, connector));
            }
        }));
    }

    protected record ProjectConnectorCallbackInfo(PublicProjectId projectId, ProjectStorageSystem projectStorageSystem, ConnectorConfiguration connector) {
    }
}

