/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.RoleSchema;
import com.teamscale.core.permissions.RoleSchemaData;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/roles")
public class RoleSchemaService
extends ApiBase {
    @GET
    @RequiresNoPermission
    @Operation(summary="Get role schema", description="Returns the RoleSchema holding all existing global and project roles.", tags={"Permission"})
    public RoleSchemaData getRoleSchema() throws StorageException {
        RoleSchema roleSchema = this.openGlobalIndex(PermissionIndex.class).getRoleSchema();
        return new RoleSchemaData(roleSchema.getGlobalRoles(), roleSchema.getProjectRoles());
    }
}

