/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/validate-connector")
public class ConnectorValidationService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @PUT
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    @Operation(summary="Validates a connector configuration", description="Validates a given connector configuration", tags={"Project"}, responses={@ApiResponse(responseCode="204", description="In case of a successful validation"), @ApiResponse(responseCode="200", description="An error message in case of validation errors")})
    public String validateConnector(@RequestBody ConnectorConfiguration connectorConfiguration, @Parameter(description="The internal project ID of the edited project.") @QueryParam(value="project-id") InternalProjectId projectId) throws StorageException {
        try {
            GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
            ConfigurationInitializationContext context = new ConfigurationInitializationContext(this.getUser().getUsername(), this.getIndexLayer(), (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION);
            InternalProjectId internalProjectId = Optional.ofNullable(projectId).orElseGet(InternalProjectId::create);
            ConnectorUtils.loadAndValidateConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)context, (InternalProjectId)internalProjectId, null);
        }
        catch (ProjectConfigurationException e) {
            LOGGER.warn("Validation failed: " + e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
        return null;
    }
}

