/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.rules;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.findings.FindingsDescriptionOverrideCache;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.rules.AnalysisGroupInfo;
import com.teamscale.service.rules.AnalysisGroupItemBase;
import com.teamscale.service.rules.AnalysisProfileRulesQueryParams;
import com.teamscale.service.rules.Metric;
import com.teamscale.service.rules.QualityIndicatorInfo;
import com.teamscale.service.rules.Rule;
import com.teamscale.service.rules.RulesCategoryBase;
import com.teamscale.service.rules.RulesContainer;
import com.teamscale.service.rules.RulesQueryParams;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.GuidelineMapping;
import eu.cqse.check.framework.core.ruleset.RulesetInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.function.SupplierWithTwoExceptions;

@Path(value="api/language-rules")
public class RulesService
extends ApiBase {
    private ConfigurationTemplate template;
    private EnumSet<ELanguage> languages;
    private EnumSet<EAnalysisTool> tools;

    @GET
    @Operation(summary="Get rules", description="Gets rules for a given language available in the current Teamscale version.", tags={"Miscellaneous"}, responses={@ApiResponse(responseCode="400", description="Language not supported.")})
    @RequiresNoPermission(description="No permission needed since every user can explore rules with the rule browser.")
    public RulesContainer getLanguageRules(@BeanParam RulesQueryParams queryParams) throws StorageException, ProjectConfigurationException {
        return this.processRequest(queryParams, (SupplierWithTwoExceptions<RulesContainer, StorageException, ProjectConfigurationException>)((SupplierWithTwoExceptions)this::createRulesContainer));
    }

    @GET
    @Path(value="{project}")
    @Operation(summary="Get enabled rules", description="Gets enabled rules for the given languages for a specific project.", tags={"Project", "Miscellaneous"}, responses={@ApiResponse(responseCode="400", description="Language not supported.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public RulesContainer getLanguageRulesForProject(@Parameter(description="The project for which to get rules.") @PathParam(value="project") PublicProjectId projectId, @BeanParam AnalysisProfileRulesQueryParams queryParams) throws StorageException, ProjectConfigurationException {
        return this.processRequest(queryParams, (SupplierWithTwoExceptions<RulesContainer, StorageException, ProjectConfigurationException>)((SupplierWithTwoExceptions)() -> this.createRulesContainerFromProject(projectId, queryParams.includeDisabledRulesAndMetrics, queryParams.includeDisabledGroups, new CodeScopeName(queryParams.codeScope))));
    }

    @GET
    @Path(value="analysis-profile/{analysisProfileName}")
    @Operation(summary="Get enabled rules", description="Gets enabled rules for the given languages and tools for a specific analysis profile.", tags={"Analysis profiles", "Miscellaneous"}, responses={@ApiResponse(responseCode="400", description="Language not supported.")})
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    public RulesContainer getLanguageRulesForAnalysisProfile(@Parameter(description="The analysis profile for which to get rules.") @PathParam(value="analysisProfileName") String analysisProfileName, @BeanParam AnalysisProfileRulesQueryParams queryParams) throws StorageException, ProjectConfigurationException {
        return this.processRequest(queryParams, (SupplierWithTwoExceptions<RulesContainer, StorageException, ProjectConfigurationException>)((SupplierWithTwoExceptions)() -> this.createRulesContainerFromAnalysisProfile(analysisProfileName, queryParams.includeDisabledRulesAndMetrics, queryParams.includeDisabledGroups)));
    }

    @GET
    @Path(value="analysis-profile/empty")
    @Operation(summary="Get enabled rules", description="Gets enabled rules for the given languages and tools for an empty analysis profile.", tags={"Analysis profiles", "Miscellaneous"}, responses={@ApiResponse(responseCode="400", description="Language not supported.")})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    public RulesContainer getLanguageRulesForEmptyAnalysisProfile(@BeanParam AnalysisProfileRulesQueryParams queryParams) throws StorageException, ProjectConfigurationException {
        return this.processRequest(queryParams, (SupplierWithTwoExceptions<RulesContainer, StorageException, ProjectConfigurationException>)((SupplierWithTwoExceptions)() -> this.createRulesContainerFromEmptyAnalysisProfile("emptyProfile", queryParams.includeDisabledRulesAndMetrics, queryParams.includeDisabledGroups)));
    }

    private RulesContainer processRequest(RulesQueryParams queryParams, SupplierWithTwoExceptions<RulesContainer, StorageException, ProjectConfigurationException> rulesContainerSupplier) throws StorageException, ProjectConfigurationException {
        if (queryParams.languages.isEmpty() || queryParams.tools.isEmpty()) {
            return RulesContainer.emptyContainer();
        }
        this.languages = EnumSet.copyOf(queryParams.languages);
        this.tools = EnumSet.copyOf(queryParams.tools);
        this.template = RulesService.createTemplate(this.languages, this.tools, this.getGlobalStorageSystem());
        return (RulesContainer)rulesContainerSupplier.get();
    }

    private RulesContainer createRulesContainer() throws StorageException {
        ListMap<String, RulesetInfo> rulesetsByCheckId = RulesService.buildCheckIdToRulesetMapping(this.languages);
        List<Rule> rules = this.getRulesFromTemplate(this.template, true, rulesetsByCheckId);
        rules.addAll(this.getUnmatchedExternalRules());
        List<AnalysisGroupInfo> analysisGroups = this.getAnalysisGroups(this.template, false, true);
        return new RulesContainer(rules, (List)rulesetsByCheckId.getValues(), RulesService.getQualityIndicators(this.template, false, analysisGroups.stream().map(RulesCategoryBase::getName).toList(), false), analysisGroups, (List<ConfigOptionDescriptorBase>)CollectionUtils.emptyList(), (List<ConfigOptionDescriptorBase>)CollectionUtils.emptyList());
    }

    private RulesContainer createRulesContainerFromProject(PublicProjectId projectId, boolean includeDisabledRules, boolean includeDisabledGroupsAndIndicators, @Nullable CodeScopeName codeScopeName) throws StorageException, ProjectConfigurationException {
        if (codeScopeName == null) {
            codeScopeName = CodeScopeAware.DEFAULT_CODE_SCOPE;
        }
        AnalysisProfile analysisProfile = AnalysisProfileUtils.getEmbeddedAnalysisProfile((IndexLayer)this.getIndexLayer(), (PublicProjectId)projectId, (CodeScopeName)codeScopeName);
        return this.getRulesFromAnalysisProfile(analysisProfile, includeDisabledRules, includeDisabledGroupsAndIndicators);
    }

    private RulesContainer createRulesContainerFromAnalysisProfile(String analysisProfileName, boolean includeDisabledRules, boolean includeDisabledGroupsAndIndicators) throws StorageException, ProjectConfigurationException {
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
        if (analysisProfile == null) {
            throw new NotFoundException("Could not find analysis profile '" + analysisProfileName + "'");
        }
        return this.getRulesFromAnalysisProfile(analysisProfile, includeDisabledRules, includeDisabledGroupsAndIndicators);
    }

    private RulesContainer createRulesContainerFromEmptyAnalysisProfile(String analysisProfileName, boolean includeDisabledRules, boolean includeDisabledGroupsAndIndicators) throws StorageException, ProjectConfigurationException {
        AnalysisProfile analysisProfile = new AnalysisProfile(analysisProfileName, Collections.emptySet(), Collections.emptySet());
        return this.getRulesFromAnalysisProfile(analysisProfile, includeDisabledRules, includeDisabledGroupsAndIndicators);
    }

    private RulesContainer getRulesFromAnalysisProfile(AnalysisProfile analysisProfile, boolean includeDisabledRulesAndMetrics, boolean includeDisabledGroupsAndIndicators) throws ProjectConfigurationException, StorageException {
        AnalysisProfileUtils.initDefaultsFromProfile((ConfigurationTemplate)this.template, (AnalysisProfile)analysisProfile, (GlobalStorageSystem)this.getGlobalStorageSystem());
        ListMap<String, RulesetInfo> rulesetsByCheckId = RulesService.buildCheckIdToRulesetMapping(this.languages);
        Map<String, String> analysisGroupToQualityIndicator = RulesService.buildGroupToQualityIndicatorMapping(this.template);
        List<Rule> rules = this.getRulesFromTemplate(this.template, includeDisabledRulesAndMetrics, rulesetsByCheckId).stream().filter(rule -> includeDisabledRulesAndMetrics || analysisGroupToQualityIndicator.get(rule.getAnalysisGroup()) != null).collect(Collectors.toList());
        if (includeDisabledRulesAndMetrics) {
            rules.addAll(this.getUnmatchedExternalRules());
        }
        List<AnalysisGroupInfo> analysisGroups = this.getAnalysisGroups(this.template, includeDisabledGroupsAndIndicators, includeDisabledRulesAndMetrics).stream().filter(analysisGroup -> includeDisabledGroupsAndIndicators || analysisGroupToQualityIndicator.containsKey(analysisGroup.getName())).toList();
        return new RulesContainer(rules, (List)rulesetsByCheckId.getValues(), RulesService.getQualityIndicators(this.template, includeDisabledGroupsAndIndicators, analysisGroups.stream().map(RulesCategoryBase::getName).toList(), true), analysisGroups, this.template.getGlobalOptions(), this.template.getQualityIndicatorOptions());
    }

    private List<Rule> getRulesFromTemplate(ConfigurationTemplate template, boolean includeDisabledRules, ListMap<String, RulesetInfo> rulesetsByCheckId) throws StorageException {
        SynchronizedCacheAccess cacheAccess = this.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(FindingsDescriptionOverrideCache.class);
        template.adjustFindingDescriptionsWithOverrideCache(cacheAccess);
        return template.getAnalysisGroups().stream().flatMap(group -> this.getRulesFromGroup((AnalysisGroupDescriptor)group, includeDisabledRules, rulesetsByCheckId).stream()).collect(Collectors.toList());
    }

    private List<Rule> getRulesFromGroup(AnalysisGroupDescriptor analysisGroup, boolean includeDisabledRules, ListMap<String, RulesetInfo> rulesetByCheckId) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        AnalysisGroupItemBase currentRule = null;
        for (ConfigurationItemBase configItem : analysisGroup.getConfigurationItems()) {
            if (configItem instanceof MetricDescriptor) {
                currentRule = null;
                continue;
            }
            if (configItem instanceof FindingDescriptor) {
                FindingDescriptor findingDescriptor = (FindingDescriptor)configItem;
                if (this.shouldIncludeRule(findingDescriptor, includeDisabledRules)) {
                    currentRule = this.createRule(findingDescriptor, analysisGroup.getName(), rulesetByCheckId, findingDescriptor.getDefaultFindingEnablement(), findingDescriptor.codeScopeAware());
                    rules.add((Rule)currentRule);
                    continue;
                }
                currentRule = null;
                continue;
            }
            if (!(configItem instanceof ConfigOptionDescriptorBase) || currentRule == null) continue;
            currentRule.addOption((ConfigOptionDescriptorBase)configItem);
        }
        return rules;
    }

    private boolean shouldIncludeRule(FindingDescriptor rule, boolean includeDisabledRules) {
        return this.tools.contains(rule.getTool()) && (includeDisabledRules || rule.getEnablement() != EFindingEnablement.OFF);
    }

    private Rule createRule(FindingDescriptor findingDescriptor, String analysisGroup, ListMap<String, RulesetInfo> rulesetByCheckId, EFindingEnablement defaultEnablement, boolean isCodeScopeAware) {
        return new Rule(findingDescriptor.getName(), findingDescriptor.getReadableName(), findingDescriptor.getDescription(), analysisGroup, RulesService.getRuleIdForFindingDescriptor(rulesetByCheckId, findingDescriptor), this.getFilteredLanguages(findingDescriptor), findingDescriptor.getTool(), findingDescriptor.getEnablement(), findingDescriptor.isAutoAllowed(), defaultEnablement, isCodeScopeAware);
    }

    private Set<ELanguage> getFilteredLanguages(FindingDescriptor findingDescriptor) {
        return findingDescriptor.getLanguages().stream().filter(language -> this.languages.contains(language)).collect(Collectors.toSet());
    }

    private static @NonNull Set<String> getRuleIdForFindingDescriptor(ListMap<String, RulesetInfo> rulesetByCheckId, FindingDescriptor findingDescriptor) {
        return new HashSet(rulesetByCheckId.getCollectionOrEmpty((Object)findingDescriptor.getName())).stream().map(rulesetInfo -> rulesetInfo.ruleId).collect(Collectors.toSet());
    }

    private static List<QualityIndicatorInfo> getQualityIndicators(ConfigurationTemplate template, boolean includeEmpty, List<String> availableAnalysisGroups, boolean includeOptions) {
        return template.getQualityIndicators().stream().filter(qualityIndicator -> includeEmpty || !RulesService.isQualityIndicatorEmpty(qualityIndicator, availableAnalysisGroups)).map(qualityIndicator -> RulesService.createQualityIndicatorInfo(qualityIndicator, includeOptions, availableAnalysisGroups)).toList();
    }

    private static boolean isQualityIndicatorEmpty(QualityIndicatorTemplate qualityIndicator, List<String> availableAnalysisGroups) {
        return qualityIndicator.getGroupNames().stream().filter(availableAnalysisGroups::contains).toList().isEmpty();
    }

    private static QualityIndicatorInfo createQualityIndicatorInfo(QualityIndicatorTemplate qualityIndicator, boolean includeOptions, List<String> availableAnalysisGroups) {
        UnmodifiableList options = Collections.emptyList();
        if (includeOptions) {
            options = qualityIndicator.getVisibleOptions();
        }
        List<String> analysisGroups = qualityIndicator.getGroupNames().stream().filter(availableAnalysisGroups::contains).toList();
        return new QualityIndicatorInfo(qualityIndicator.getName(), (List<ConfigOptionDescriptorBase>)options, analysisGroups);
    }

    private List<AnalysisGroupInfo> getAnalysisGroups(ConfigurationTemplate template, boolean includeEmptyGroups, boolean includeDisabledRulesAndMetrics) {
        return template.getAnalysisGroups().stream().map(analysisGroup -> this.createAnalysisGroupInfo((AnalysisGroupDescriptor)analysisGroup, includeDisabledRulesAndMetrics)).filter(analysisGroupInfo -> includeEmptyGroups || !analysisGroupInfo.isEmpty()).toList();
    }

    private AnalysisGroupInfo createAnalysisGroupInfo(AnalysisGroupDescriptor analysisGroup, boolean includeDisabledRulesAndMetrics) {
        List<String> rules = analysisGroup.getConfigurationItems().stream().filter(configItem -> {
            FindingDescriptor findingDescriptor;
            return configItem instanceof FindingDescriptor && this.shouldIncludeRule(findingDescriptor = (FindingDescriptor)configItem, includeDisabledRulesAndMetrics);
        }).map(ConfigurationItemBase::getName).toList();
        List<ConfigOptionDescriptorBase> options = RulesService.getOptionsForGroup(analysisGroup);
        List<Metric> metrics = RulesService.getMetricsForGroup(analysisGroup, includeDisabledRulesAndMetrics);
        return new AnalysisGroupInfo(analysisGroup.getName(), metrics, rules, options);
    }

    private static List<Metric> getMetricsForGroup(AnalysisGroupDescriptor analysisGroup, boolean includeDisabledMetrics) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        AnalysisGroupItemBase currentMetric = null;
        for (ConfigurationItemBase configItem : analysisGroup.getConfigurationItems()) {
            if (configItem instanceof FindingDescriptor) {
                currentMetric = null;
                continue;
            }
            if (configItem instanceof MetricDescriptor) {
                MetricDescriptor metricDescriptor = (MetricDescriptor)configItem;
                if (includeDisabledMetrics || metricDescriptor.isMetricEnabled()) {
                    currentMetric = new Metric(metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.isMetricEnabled(), metricDescriptor.codeScopeAware());
                    metrics.add((Metric)currentMetric);
                    continue;
                }
                currentMetric = null;
                continue;
            }
            if (!(configItem instanceof ConfigOptionDescriptorBase) || currentMetric == null) continue;
            currentMetric.addOption((ConfigOptionDescriptorBase)configItem);
        }
        return metrics;
    }

    private static List<ConfigOptionDescriptorBase> getOptionsForGroup(AnalysisGroupDescriptor analysisGroup) {
        ConfigurationItemBase configItem;
        ArrayList<ConfigOptionDescriptorBase> options = new ArrayList<ConfigOptionDescriptorBase>();
        UnmodifiableIterator unmodifiableIterator = analysisGroup.getConfigurationItems().iterator();
        while (unmodifiableIterator.hasNext() && !((configItem = (ConfigurationItemBase)unmodifiableIterator.next()) instanceof MetricDescriptor) && !(configItem instanceof FindingDescriptor)) {
            if (!(configItem instanceof ConfigOptionDescriptorBase)) continue;
            ConfigOptionDescriptorBase configOption = (ConfigOptionDescriptorBase)configItem;
            options.add(configOption);
        }
        return options;
    }

    private static Map<String, String> buildGroupToQualityIndicatorMapping(ConfigurationTemplate template) {
        HashMap<String, String> groupToIndicator = new HashMap<String, String>();
        for (QualityIndicatorTemplate qualityIndicator : template.getQualityIndicators()) {
            for (String analysisGroup : qualityIndicator.getGroupNames()) {
                groupToIndicator.put(analysisGroup, qualityIndicator.getName());
            }
        }
        return groupToIndicator;
    }

    private List<Rule> getUnmatchedExternalRules() throws StorageException {
        ExternalFindingsGroupDescriptionIndex externalFindingsIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        PairList descriptionsAndTools = externalFindingsIndex.getAllDescriptionsWithTools();
        List groups = externalFindingsIndex.getAllGroups();
        return descriptionsAndTools.stream().filter(description -> groups.stream().noneMatch(group -> group.contains(((ExternalFindingsDescription)description.getFirst()).getTypeId()))).map(description -> new Rule(((ExternalFindingsDescription)description.getFirst()).getTypeId(), ((ExternalFindingsDescription)description.getFirst()).getName(), ((ExternalFindingsDescription)description.getFirst()).getDescription(), null, Collections.emptySet(), Collections.emptySet(), (EAnalysisTool)description.getSecond(), EFindingEnablement.OFF, false, ((ExternalFindingsDescription)description.getFirst()).getEnablement(), false)).collect(Collectors.toList());
    }

    public static ConfigurationTemplate createTemplate(Set<ELanguage> languages, Set<EAnalysisTool> tools, GlobalStorageSystem storageSystem) {
        try {
            return ConfigRegistry.getInstance().createConfigurationTemplate(languages, tools, storageSystem);
        }
        catch (ProjectConfigurationException e) {
            throw new InternalServerErrorException("Failed to create configuration template", (Throwable)e);
        }
    }

    private static ListMap<String, RulesetInfo> buildCheckIdToRulesetMapping(Set<ELanguage> languages) {
        return GuidelineMapping.getInstance().getRulesByCheckId(languages);
    }
}

