/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.information_retrieval.scoring;

import com.teamscale.index.tests.information_retrieval.data.Term;
import com.teamscale.service.testimpact.information_retrieval.ITfIdfGroundTruth;
import com.teamscale.service.testimpact.information_retrieval.scoring.ScoringOperatorBase;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class LucenePracticalScoringOperator
extends ScoringOperatorBase {
    LucenePracticalScoringOperator(ITfIdfGroundTruth groundTruth, CounterSet<Term> changeRequestTerms, int calculateTopK) {
        super(groundTruth, changeRequestTerms, calculateTopK);
    }

    @Override
    public double scoreTestImplementation(UniformPath uniformPath, CounterSet<Term> changeQueryTerms, CounterSet<Term> testImplementationTerms) throws StorageException {
        double result = 0.0;
        List<Term> changeQueryTermList = List.copyOf(changeQueryTerms.getKeys());
        for (Term term : changeQueryTermList) {
            int numberOfDocumentsContainingTerm = this.groundTruth.getNumberOfDocumentsContaining(term);
            double termBoost = 1.0;
            double termNormalizationFactor = 1.0 / Math.sqrt(testImplementationTerms.getKeys().size());
            double termFrequency = Math.sqrt(testImplementationTerms.getValue((Object)term));
            double termInverseDocumentFrequency = 1.0 + Math.log((1.0 + (double)this.groundTruth.totalNumberOfDocuments()) / (1.0 + (double)numberOfDocumentsContainingTerm));
            double termContribution = termFrequency * termInverseDocumentFrequency * termInverseDocumentFrequency * termBoost * termNormalizationFactor;
            this.storeTermContributions(term, termContribution);
            result += termContribution;
        }
        return result;
    }
}

