/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.information_retrieval.scoring;

import com.teamscale.index.tests.information_retrieval.data.Term;
import com.teamscale.service.testimpact.information_retrieval.ITfIdfGroundTruth;
import com.teamscale.service.testimpact.information_retrieval.scoring.BM25ScoringOperator;
import com.teamscale.service.testimpact.information_retrieval.scoring.EScoringOperator;
import com.teamscale.service.testimpact.information_retrieval.scoring.IScoringOperator;
import com.teamscale.service.testimpact.information_retrieval.scoring.LucenePracticalScoringOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CounterSet;

public class ScoringOperatorFactory {
    public static IScoringOperator createScoringOperator(@Nullable EScoringOperator scoringOperator, ITfIdfGroundTruth groundTruth, CounterSet<Term> changeRequestTerms, int calculateTopK) {
        if (scoringOperator == null) {
            scoringOperator = EScoringOperator.BM25;
        }
        return switch (scoringOperator) {
            default -> throw new MatchException(null, null);
            case EScoringOperator.LUCENE_PRACTICAL_SCORING -> new LucenePracticalScoringOperator(groundTruth, changeRequestTerms, calculateTopK);
            case EScoringOperator.BM25 -> new BM25ScoringOperator(groundTruth, changeRequestTerms, calculateTopK);
        };
    }
}

