/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.scm_manager.ScmManagerChangeRetriever;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestUpdateTrigger;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/scm-manager/web-hook")
public class ScmManagerWebHookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ScmManagerWebHookService() {
        super(ScmManagerChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles the incoming requests from the SCM-Manager server.", description="Handles the incoming requests from the SCM-Manager server and processes the request body depending on the event. The events which are handled by the service are 'SCM-Push-Event'", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHook(@HeaderParam(value="X-SCM-Event") String event, @RequestBody byte[] requestBody) throws StorageException {
        String queryContent = StringUtils.bytesToString((byte[])requestBody);
        LOGGER.debug("Received a web hook request from SCM-Manager with event \"{}\" and payload: {}", (Object)event, (Object)queryContent);
        if (StringUtils.isEmpty((String)event)) {
            throw new BadRequestException("Event header missing!");
        }
        switch (event) {
            case "SCM-Push-Event": {
                this.handleCommitPush(queryContent);
                break;
            }
            case "SCM-Pull-Request-Created-Event": 
            case "SCM-Pull-Request-Updated-Event": {
                this.handlePullRequestUpdate(queryContent);
                break;
            }
        }
        return Response.ok().build();
    }

    private void handlePullRequestUpdate(String payload) throws StorageException {
        ScmPullRequestEvent pullRequestEventPayload;
        try {
            pullRequestEventPayload = (ScmPullRequestEvent)JsonUtils.deserializeFromJson((String)payload, ScmPullRequestEvent.class);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
        this.scheduleMergeRequestUpdateTriggers(pullRequestEventPayload.repositoryUrl, pullRequestEventPayload.repositoryId, pullRequestEventPayload.getPullRequestId(), ScmManagerMergeRequestUpdateTrigger.class, null);
    }

    private void handleCommitPush(String payload) throws BadRequestException, StorageException {
        ScmPushEvent pushPayload;
        try {
            pushPayload = (ScmPushEvent)JsonUtils.deserializeFromJson((String)payload, ScmPushEvent.class);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)pushPayload.repositoryUrl, (IndexLayer)this.getIndexLayer(), null);
    }

    private static class ScmPullRequestEvent {
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="pullRequestId")
        private String pullRequestId;

        private ScmPullRequestEvent() {
        }

        private long getPullRequestId() {
            return Long.parseLong(this.pullRequestId);
        }
    }

    private static class ScmPushEvent {
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="branchName")
        private String branchName;

        private ScmPushEvent() {
        }
    }
}

