/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.auth;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.bozaro.gitlfs.client.auth.AuthProvider;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H$J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/bozaro/gitlfs/client/auth/CachedAuthProvider;", "Lru/bozaro/gitlfs/client/auth/AuthProvider;", "()V", "authCache", "Ljava/util/concurrent/ConcurrentMap;", "Lru/bozaro/gitlfs/common/data/Operation;", "Lru/bozaro/gitlfs/common/data/Link;", "locks", "Ljava/util/EnumMap;", "", "getAuth", "operation", "getAuthUncached", "invalidateAuth", "", "auth", "Companion", "gitlfs-client"})
public abstract class CachedAuthProvider
implements AuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Operation, Link> authCache;
    @NotNull
    private final EnumMap<Operation, Object> locks = ru.bozaro.gitlfs.client.auth.CachedAuthProvider$Companion.access$createLocks(Companion);

    public CachedAuthProvider() {
        this.authCache = new ConcurrentHashMap(Operation.values().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Link getAuth(@NotNull Operation operation) throws IOException {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Link auth = null;
        auth = (Link)this.authCache.get(operation);
        if (auth == null) {
            Object object = this.locks.get(operation);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                auth = (Link)this.authCache.get(operation);
                if (auth == null) {
                    try {
                        auth = this.getAuthUncached(operation);
                        ((Map)this.authCache).put(operation, auth);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Link link = auth;
        Intrinsics.checkNotNull(link);
        return link;
    }

    @NotNull
    protected abstract Link getAuthUncached(@NotNull Operation var1) throws IOException, InterruptedException;

    @Override
    public void invalidateAuth(@NotNull Operation operation, @NotNull Link auth) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        this.authCache.remove(operation, auth);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lru/bozaro/gitlfs/client/auth/CachedAuthProvider$Companion;", "", "()V", "createLocks", "Ljava/util/EnumMap;", "Lru/bozaro/gitlfs/common/data/Operation;", "gitlfs-client"})
    public static final class Companion {
        private Companion() {
        }

        private final EnumMap<Operation, Object> createLocks() {
            EnumMap<Operation, Object> result = new EnumMap<Operation, Object>(Operation.class);
            for (Operation value : Operation.values()) {
                ((Map)result).put(value, new Object());
            }
            return result;
        }

        public static final /* synthetic */ EnumMap access$createLocks(Companion $this) {
            return $this.createLocks();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

