/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lru/bozaro/gitlfs/client/internal/LfsRequest;", "", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "entity", "Lorg/apache/http/entity/AbstractHttpEntity;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/entity/AbstractHttpEntity;)V", "addHeaders", "headers", "", "", "gitlfs-client"})
public final class LfsRequest {
    @NotNull
    private final HttpUriRequest request;
    @Nullable
    private final AbstractHttpEntity entity;

    public LfsRequest(@NotNull HttpUriRequest request, @Nullable AbstractHttpEntity entity) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.entity = entity;
    }

    @NotNull
    public final HttpUriRequest addHeaders(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (Intrinsics.areEqual((Object)"Transfer-Encoding", (Object)key)) {
                if (this.entity == null) continue;
                boolean chunked = Intrinsics.areEqual((Object)"chunked", (Object)value);
                this.entity.setChunked(chunked);
                continue;
            }
            this.request.addHeader(key, value);
        }
        return this.request;
    }
}

