/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.rocksdb.Cache;
import org.rocksdb.MemoryUsageType;
import org.rocksdb.RocksDB;

public class MemoryUtil {
    public static Map<MemoryUsageType, Long> getApproximateMemoryUsageByType(List<RocksDB> dbs, Set<Cache> caches) {
        int dbCount = dbs == null ? 0 : dbs.size();
        int cacheCount = caches == null ? 0 : caches.size();
        long[] dbHandles = new long[dbCount];
        long[] cacheHandles = new long[cacheCount];
        if (dbCount > 0) {
            ListIterator<RocksDB> dbIter = dbs.listIterator();
            while (dbIter.hasNext()) {
                dbHandles[dbIter.nextIndex()] = dbIter.next().nativeHandle_;
            }
        }
        if (cacheCount > 0) {
            int i = 0;
            for (Cache cache : caches) {
                cacheHandles[i] = cache.nativeHandle_;
                ++i;
            }
        }
        Map<Byte, Long> byteOutput = MemoryUtil.getApproximateMemoryUsageByType(dbHandles, cacheHandles);
        HashMap<MemoryUsageType, Long> output = new HashMap<MemoryUsageType, Long>();
        for (Map.Entry<Byte, Long> longEntry : byteOutput.entrySet()) {
            output.put(MemoryUsageType.getMemoryUsageType(longEntry.getKey()), longEntry.getValue());
        }
        return output;
    }

    private static native Map<Byte, Long> getApproximateMemoryUsageByType(long[] var0, long[] var1);
}

