/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.EnumSet;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.StatsLevel;
import org.rocksdb.TickerType;

public class Statistics
extends RocksObject {
    public Statistics() {
        super(Statistics.newStatistics());
    }

    public Statistics(Statistics otherStatistics) {
        super(Statistics.newStatistics(otherStatistics.nativeHandle_));
    }

    public Statistics(EnumSet<HistogramType> ignoreHistograms) {
        super(Statistics.newStatistics(Statistics.toArrayValues(ignoreHistograms)));
    }

    public Statistics(EnumSet<HistogramType> ignoreHistograms, Statistics otherStatistics) {
        super(Statistics.newStatistics(Statistics.toArrayValues(ignoreHistograms), otherStatistics.nativeHandle_));
    }

    Statistics(long existingStatisticsHandle) {
        super(existingStatisticsHandle);
    }

    private static byte[] toArrayValues(EnumSet<HistogramType> histogramTypes) {
        byte[] values = new byte[histogramTypes.size()];
        int i = 0;
        for (HistogramType histogramType : histogramTypes) {
            values[i++] = histogramType.getValue();
        }
        return values;
    }

    public StatsLevel statsLevel() {
        return StatsLevel.getStatsLevel(this.statsLevel(this.nativeHandle_));
    }

    public void setStatsLevel(StatsLevel statsLevel) {
        this.setStatsLevel(this.nativeHandle_, statsLevel.getValue());
    }

    public long getTickerCount(TickerType tickerType) {
        assert (this.isOwningHandle());
        return this.getTickerCount(this.nativeHandle_, tickerType.getValue());
    }

    public long getAndResetTickerCount(TickerType tickerType) {
        assert (this.isOwningHandle());
        return this.getAndResetTickerCount(this.nativeHandle_, tickerType.getValue());
    }

    public HistogramData getHistogramData(HistogramType histogramType) {
        assert (this.isOwningHandle());
        return this.getHistogramData(this.nativeHandle_, histogramType.getValue());
    }

    public String getHistogramString(HistogramType histogramType) {
        assert (this.isOwningHandle());
        return this.getHistogramString(this.nativeHandle_, histogramType.getValue());
    }

    public void reset() throws RocksDBException {
        assert (this.isOwningHandle());
        this.reset(this.nativeHandle_);
    }

    public String toString() {
        assert (this.isOwningHandle());
        return this.toString(this.nativeHandle_);
    }

    private static native long newStatistics();

    private static native long newStatistics(long var0);

    private static native long newStatistics(byte[] var0);

    private static native long newStatistics(byte[] var0, long var1);

    @Override
    protected final native void disposeInternal(long var1);

    private native byte statsLevel(long var1);

    private native void setStatsLevel(long var1, byte var3);

    private native long getTickerCount(long var1, byte var3);

    private native long getAndResetTickerCount(long var1, byte var3);

    private native HistogramData getHistogramData(long var1, byte var3);

    private native String getHistogramString(long var1, byte var3);

    private native void reset(long var1) throws RocksDBException;

    private native String toString(long var1);
}

