/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.visiting.KtTreeVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/SingleConstructorCallExtractor;", "Lorg/sonarsource/kotlin/api/visiting/KtTreeVisitor;", "singletonClassCandidates", "", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "constructorMatcher", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "singleConstructorCallByClass", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getSingleConstructorCallByClass", "()Ljava/util/Map;", "visitCallExpression", "", "expression", "sonar-kotlin-checks"})
final class SingleConstructorCallExtractor
extends KtTreeVisitor {
    @NotNull
    private final Set<String> singletonClassCandidates;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final Map<String, KtCallExpression> singleConstructorCallByClass;
    @NotNull
    private FunMatcherImpl constructorMatcher;

    public SingleConstructorCallExtractor(@NotNull Set<String> singletonClassCandidates, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter(singletonClassCandidates, "singletonClassCandidates");
        Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
        this.singletonClassCandidates = singletonClassCandidates;
        this.bindingContext = bindingContext2;
        this.singleConstructorCallByClass = new LinkedHashMap();
        this.constructorMatcher = FunMatcherKt.ConstructorMatcher$default(null, new Function1<FunMatcherBuilderContext, Unit>(this){
            final /* synthetic */ SingleConstructorCallExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FunMatcherBuilderContext $this$ConstructorMatcher) {
                Intrinsics.checkNotNullParameter($this$ConstructorMatcher, "$this$ConstructorMatcher");
                Collection $this$toTypedArray$iv = SingleConstructorCallExtractor.access$getSingletonClassCandidates$p(this.this$0);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                $this$ConstructorMatcher.withTypeNames(Arrays.copyOf(stringArray, stringArray.length));
            }
        }, 1, null);
    }

    @NotNull
    public final Map<String, KtCallExpression> getSingleConstructorCallByClass() {
        return this.singleConstructorCallByClass;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        block2: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (this.singletonClassCandidates.isEmpty() || !this.constructorMatcher.matches(expression2, this.bindingContext)) {
                return;
            }
            ResolvedCall resolvedCall2 = (ResolvedCall)this.bindingContext.get(BindingContext.RESOLVED_CALL, CallUtilKt.getCall(expression2, this.bindingContext));
            Object d = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            ConstructorDescriptor constructorDescriptor = d instanceof ConstructorDescriptor ? (ConstructorDescriptor)d : null;
            if (constructorDescriptor == null) {
                return;
            }
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor;
            ClassDescriptor classDescriptor2 = constructorDescriptor2.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getConstructedClass(...)");
            String string2 = DescriptorUtilsKt.getFqNameSafe(classDescriptor2).asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String fqName2 = string2;
            KtCallExpression ktCallExpression = this.singleConstructorCallByClass.put(fqName2, expression2);
            if (ktCallExpression == null) break block2;
            KtCallExpression it = ktCallExpression;
            boolean bl = false;
            this.singleConstructorCallByClass.remove(fqName2);
            this.singletonClassCandidates.remove(fqName2);
            this.constructorMatcher = FunMatcherKt.ConstructorMatcher$default(null, new Function1<FunMatcherBuilderContext, Unit>(this){
                final /* synthetic */ SingleConstructorCallExtractor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull FunMatcherBuilderContext $this$ConstructorMatcher) {
                    Intrinsics.checkNotNullParameter($this$ConstructorMatcher, "$this$ConstructorMatcher");
                    Collection $this$toTypedArray$iv = SingleConstructorCallExtractor.access$getSingletonClassCandidates$p(this.this$0);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    $this$ConstructorMatcher.withTypeNames(Arrays.copyOf(stringArray, stringArray.length));
                }
            }, 1, null);
        }
    }

    public static final /* synthetic */ Set access$getSingletonClassCandidates$p(SingleConstructorCallExtractor $this) {
        return $this.singletonClassCandidates;
    }
}

