/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import com.teamscale.commons.annotation.ClassIndexUtils;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.CheckInstance;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.registry.CheckLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.util.clang.ClangUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.ClassPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CheckRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static CheckRegistry instance = null;
    private final Map<String, CheckInfo> checksInfo = new HashMap<String, CheckInfo>();
    private final Map<String, Class<? extends IGlobalExtractionPhase<?, ?>>> checkPhases = new HashMap();
    private final ListMap<String, CheckInfo> checksPerLocation = new ListMap();

    CheckRegistry() {
        this.registerChecksByServiceLoader();
    }

    public static synchronized CheckRegistry getInstance() {
        if (instance == null) {
            instance = new CheckRegistry();
        }
        return instance;
    }

    private void registerChecksByServiceLoader() {
        List checkClasses = ClassIndexUtils.getAnnotated(Check.class);
        for (Class checkClass : checkClasses) {
            String separator;
            if (CheckRegistry.shouldSkipCheck(checkClass)) continue;
            String fullLocation = StringUtils.normalizeLineSeparatorsPlatformIndependent((String)checkClass.getResource(checkClass.getSimpleName() + ".class").getPath());
            if (!fullLocation.contains(separator = "/classes/")) {
                separator = ".jar!";
            }
            String location = (String)StringUtils.splitAtFirst((String)fullLocation, (String)separator).getFirst();
            try {
                this.loadCheckFromClass(checkClass, location);
            }
            catch (IOException | NoClassDefFoundError e) {
                LOGGER.error("Failed to load check from class: {}", (Object)checkClass, (Object)e);
            }
        }
    }

    private static boolean shouldSkipCheck(Class<?> checkClass) {
        return checkClass.getPackage().getName().equals("com.teamscale.index.audit.checks") && !EFeatureToggle.AUDIT_FEATURES.isEnabled();
    }

    public void registerChecksFromClasspathDirectory(File classesDirectory) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.registerChecksFromClasspathDirectory(classesDirectory, classLoader, classesDirectory.getCanonicalFile().getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load checks directory: {}", (Object)classesDirectory, (Object)e);
        }
    }

    private int registerChecksFromClasspathDirectory(File classesDirectory, ClassLoader classLoader, String loadingPath) throws IOException {
        int count = 0;
        List classNames = ClassPathUtils.getClassNames((File)classesDirectory);
        for (String className : classNames) {
            try {
                if (!this.loadCheckFromClass(classLoader.loadClass(className), loadingPath)) continue;
                ++count;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                LOGGER.error("Failed to load check from class: " + className, e);
            }
        }
        return count;
    }

    public void registerCheckDirectory(File customChecksDirectory) {
        if (!customChecksDirectory.canRead()) {
            LOGGER.error("Cannot read from custom check directory: " + customChecksDirectory.getAbsolutePath());
            return;
        }
        try {
            Files.walkFileTree(customChecksDirectory.toPath(), new CustomCheckLoader());
        }
        catch (IOException e) {
            LOGGER.error("Cannot traverse custom check directory: " + customChecksDirectory.getAbsolutePath());
        }
    }

    public void loadChecksFromJar(File jarFile) {
        try {
            URLClassLoader classLoader = CheckRegistry.createClassLoader(jarFile);
            for (String className : FileSystemUtils.listTopLevelClassesInJarFile((File)jarFile)) {
                this.loadCheckFromClass(classLoader.loadClass(className), jarFile.getCanonicalFile().getAbsolutePath());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Error loading custom checks from jar '" + String.valueOf(jarFile) + "': " + e.toString(), (Throwable)e);
        }
    }

    private void loadChecksFromClasses(File classesDir) {
        try {
            this.registerChecksFromClasspathDirectory(classesDir, CheckRegistry.createClassLoader(classesDir), classesDir.getCanonicalFile().getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Error loading custom checks classes dir '" + String.valueOf(classesDir) + "': " + e.toString(), (Throwable)e);
        }
    }

    private static URLClassLoader createClassLoader(File classpath) throws MalformedURLException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return new URLClassLoader(new URL[]{classpath.toURI().toURL()}, contextClassLoader);
    }

    private boolean loadCheckFromClass(Class<?> clazz, String location) throws IOException {
        CheckInfo checkInfo;
        try {
            checkInfo = CheckLoader.loadFromClass(clazz);
        }
        catch (CheckException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (checkInfo == null) {
            return false;
        }
        if (this.checksInfo.containsKey(checkInfo.getIdentifier())) {
            LOGGER.error("Check {}:{} is already registered.", (Object)checkInfo.getGroupName(), (Object)checkInfo.getId());
            return false;
        }
        for (Class<IGlobalExtractionPhase<?, ?>> phase : checkInfo.getRequiredPhases()) {
            Class<? extends IGlobalExtractionPhase<?, ?>> existingPhase = this.checkPhases.get(phase.getName());
            if (existingPhase != null && existingPhase != phase) {
                throw new IOException("Check phase '" + phase.getName() + "' registered twice via different classloaders.");
            }
            if (CheckRegistry.checkPhaseIsValid(phase)) {
                this.checkPhases.put(phase.getName(), phase);
                continue;
            }
            LOGGER.error("Skipping registration of check phase {}", (Object)phase.getName());
        }
        this.checksInfo.put(checkInfo.getIdentifier(), checkInfo);
        this.checksPerLocation.add((Object)location, (Object)checkInfo);
        return true;
    }

    private static boolean checkPhaseIsValid(Class<? extends IGlobalExtractionPhase<?, ?>> phase) {
        try {
            IGlobalExtractionPhase<?, ?> phaseInstance = phase.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (ECheckParameter parameter : phaseInstance.getRequiredContextParameters()) {
                if (CheckRegistry.checkPhaseParameterIsValid(phaseInstance, parameter)) continue;
                return false;
            }
            return true;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Could not instantiate check phase {}", (Object)phase.getName(), (Object)e);
            return false;
        }
    }

    private static boolean checkPhaseParameterIsValid(IGlobalExtractionPhase<?, ?> phaseInstance, ECheckParameter parameter) {
        switch (parameter) {
            case ABSTRACT_SYNTAX_TREE: 
            case TYPE_RESOLUTION: {
                if (CheckRegistry.allPhaseLanguagesSupportParsing(phaseInstance)) break;
                return false;
            }
            case CLANG: {
                if (CheckRegistry.allPhaseLanguagesSupportClang(phaseInstance)) break;
                return false;
            }
            case RUN_ON_HIDDEN_ELEMENTS: {
                break;
            }
            case PREPROCESSOR_EXPANSIONS: {
                break;
            }
            default: {
                LOGGER.error(parameter.name() + " must be a new check parameter. Please add validation case.");
                return false;
            }
        }
        return true;
    }

    private static boolean allPhaseLanguagesSupportClang(IGlobalExtractionPhase<?, ?> phaseInstance) {
        EnumSet<ELanguage> invalidLanguages = EnumSet.copyOf(phaseInstance.getLanguages());
        invalidLanguages.removeAll(ClangUtils.CLANG_ENABLED_LANGUAGES);
        if (!invalidLanguages.isEmpty()) {
            LOGGER.error("Check phase " + phaseInstance.getClass().getName() + " requires CLANG but selects languages without clang support: " + String.valueOf(invalidLanguages));
            return false;
        }
        return true;
    }

    private static boolean allPhaseLanguagesSupportParsing(IGlobalExtractionPhase<?, ?> phaseInstance) {
        EnumSet<ELanguage> invalidLanguages = EnumSet.copyOf(phaseInstance.getLanguages());
        invalidLanguages.removeAll(ShallowParserFactory.getSupportedLanguages());
        if (!invalidLanguages.isEmpty()) {
            LOGGER.error("Check phase " + phaseInstance.getClass().getName() + " requires AST but selects languages without parser: " + String.valueOf(invalidLanguages));
            return false;
        }
        return true;
    }

    public Class<? extends IGlobalExtractionPhase<?, ?>> getCheckPhase(String phaseName) {
        return this.checkPhases.get(phaseName);
    }

    public CheckInstance instantiateCheck(String checkIdentifier) throws CheckException {
        CheckInfo checkInfo = this.checksInfo.get(checkIdentifier);
        CCSMAssert.isNotNull((Object)checkInfo, (String)("No such check: " + checkIdentifier));
        return new CheckInstance(checkInfo);
    }

    public CheckInfo getCheckInfo(String checkIdentifier) {
        return this.checksInfo.get(checkIdentifier);
    }

    public Collection<CheckInfo> getChecksInfos() {
        return CollectionUtils.asUnmodifiable(this.checksInfo.values());
    }

    public ListMap<String, CheckInfo> getChecksPerLocation() {
        return this.checksPerLocation;
    }

    private final class CustomCheckLoader
    extends SimpleFileVisitor<Path> {
        private CustomCheckLoader() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path classes = dir.resolve("classes/java/main");
            if (Files.isDirectory(classes, new LinkOption[0])) {
                LOGGER.info("Registering custom checks from classes: " + String.valueOf(classes));
                CheckRegistry.this.loadChecksFromClasses(classes.toFile());
                return FileVisitResult.SKIP_SUBTREE;
            }
            classes = dir.resolve("classes");
            if (Files.isDirectory(classes, new LinkOption[0]) && !FileSystemUtils.normalizeSeparators((String)classes.toString()).contains("/test/")) {
                LOGGER.info("Registering custom checks from classes: " + String.valueOf(classes));
                CheckRegistry.this.loadChecksFromClasses(classes.toFile());
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (file.toString().endsWith(".jar")) {
                LOGGER.info("Registering custom checks from jar: " + String.valueOf(file));
                CheckRegistry.this.loadChecksFromJar(file.toFile());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

