/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.CompilerDefinedMacroNames;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class NonStandardSemanticsMacroInvocationProcessor {
    public static boolean isNonStandardSemanticsMacro(MacroDefinition macroDefinition, CPreprocessor.FilePreprocessorContext context) {
        return CompilerDefinedMacroNames.TEAMSCALE_FILE.getDefinition(context.translationUnitLanguage).equals(macroDefinition) || CompilerDefinedMacroNames.PRAGMA1.getDefinition(context.translationUnitLanguage).equals(macroDefinition) || CompilerDefinedMacroNames.PRAGMA2.getDefinition(context.translationUnitLanguage).equals(macroDefinition);
    }

    public static List<IToken> evaluateNonStandardSemanticsMacro(List<IToken> macroExpansion, PairList<String, List<IToken>> expandedArguments, MacroDefinition currentMacro, CPreprocessor.FilePreprocessorContext context) {
        if (CompilerDefinedMacroNames.TEAMSCALE_FILE.getDefinition(context.translationUnitLanguage).equals(currentMacro)) {
            List<IToken> expansion = NonStandardSemanticsMacroInvocationProcessor.evaluateTeamscaleFileMacro(expandedArguments, context);
            if (expansion != null) {
                return expansion;
            }
        } else if (CompilerDefinedMacroNames.PRAGMA1.getDefinition(context.translationUnitLanguage).equals(currentMacro)) {
            macroExpansion = NonStandardSemanticsMacroInvocationProcessor.expandC99PragmaMacro(macroExpansion, expandedArguments);
        } else if (CompilerDefinedMacroNames.PRAGMA2.getDefinition(context.translationUnitLanguage).equals(currentMacro)) {
            macroExpansion = NonStandardSemanticsMacroInvocationProcessor.expandMicrosoftPragmaMacro(expandedArguments, context);
        }
        return macroExpansion;
    }

    private static @Nullable List<IToken> evaluateTeamscaleFileMacro(PairList<String, List<IToken>> expandedArguments, CPreprocessor.FilePreprocessorContext context) {
        if (!(expandedArguments.getSecondList().isEmpty() || ((List)expandedArguments.getSecondList().get(0)).isEmpty() || ((IToken)((List)expandedArguments.getSecondList().get(0)).get(0)).getText().isEmpty())) {
            IToken regexParameterToken = (IToken)((List)expandedArguments.getSecondList().get(0)).get(0);
            String regexParameter = StringUtils.removeDoubleQuotes((String)regexParameterToken.getText());
            try {
                if (context.uniformPath.matches(regexParameter)) {
                    return ScannerUtils.getTokens("1", regexParameterToken.getLanguage(), "##teamscale special macro##");
                }
                return ScannerUtils.getTokens("0", regexParameterToken.getLanguage(), "##teamscale special macro##");
            }
            catch (PatternSyntaxException e) {
                throw new PatternSyntaxException("Could not parse argument to " + String.valueOf((Object)CompilerDefinedMacroNames.TEAMSCALE_FILE) + " as java regex:\n" + e.getMessage(), e.getPattern(), e.getIndex());
            }
        }
        return null;
    }

    private static List<IToken> expandC99PragmaMacro(List<IToken> macroExpansion, PairList<String, List<IToken>> expandedArguments) {
        if (expandedArguments.size() != 1 || ((List)expandedArguments.getSecond(0)).size() != 1 || ((IToken)((List)expandedArguments.getSecond(0)).get(0)).getType() != ETokenType.STRING_LITERAL) {
            return macroExpansion;
        }
        IToken parameterLiteralToken = (IToken)((List)expandedArguments.getSecond(0)).get(0);
        String parameterLiteralText = parameterLiteralToken.getText();
        parameterLiteralText = StringUtils.stripSuffix((String)StringUtils.stripPrefix((String)parameterLiteralText, (String)"\""), (String)"\"");
        parameterLiteralText = parameterLiteralText.replace("\\\"", "\"").replace("\\\\", "\\");
        String replacementText = "#pragma " + parameterLiteralText;
        return ScannerUtils.getTokens(replacementText, parameterLiteralToken.getLanguage(), "##macro##");
    }

    private static List<IToken> expandMicrosoftPragmaMacro(PairList<String, List<IToken>> expandedArguments, CPreprocessor.FilePreprocessorContext context) {
        if (expandedArguments.size() == 0 || ((List)expandedArguments.getSecond(0)).isEmpty()) {
            return ScannerUtils.getTokens("#pragma", context.translationUnitLanguage, "##macro##");
        }
        List parameterTokens = (List)expandedArguments.getSecond(0);
        String pragmaDirectiveText = "#pragma " + TokenStreamTextUtils.concatTokenTexts(parameterTokens, " ");
        return ScannerUtils.getTokens(pragmaDirectiveText, context.translationUnitLanguage, "##macro##");
    }
}

