/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.StringPlatformCondition;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Unmodifiable;

class EnumPlatformCondition
extends StringPlatformCondition {
    public final @NonNull @Unmodifiable Set<String> possibleValues;

    public EnumPlatformCondition(@NonNull String name, @NonNull @Unmodifiable Set<String> possibleValues) {
        super(name);
        Preconditions.checkNotNull(possibleValues);
        Preconditions.checkArgument((!possibleValues.isEmpty() ? 1 : 0) != 0);
        this.possibleValues = possibleValues;
    }

    @Override
    public @NonNull EnumPlatformCondition copyWithName(@NonNull String newName) {
        return new EnumPlatformCondition(newName, this.possibleValues);
    }

    @Override
    public @NonNull PlatformConditionParseResult parse(@NonNull TokenStream tokenStream) throws ParseException {
        StringPlatformCondition.StringParseResult stringParseResult = this.parseAsStringValue(tokenStream);
        String value = stringParseResult.valueToken().getText();
        if (!this.possibleValues.contains(value)) {
            LOGGER.debug("Swift platform condition '{}': Unexpected value '{}' at '{}:{}'", (Object)value, (Object)this.name, (Object)stringParseResult.valueToken().getOriginId(), (Object)(stringParseResult.valueToken().getLineNumber() + 1));
        }
        tokenStream.advancePosition(stringParseResult.tokenCount());
        return new PlatformConditionParseResult(this, new StringPlatformCondition.Value(value));
    }

    @Override
    public @NonNull Object parseConfig(@NonNull String configValue) throws ParseException {
        if (StringUtils.isEmpty((String)configValue)) {
            throw new ParseException("Empty configuration value");
        }
        if (!this.possibleValues.contains(configValue)) {
            LOGGER.warn("Swift platform condition '{}': Unknown value '{}' in configuration, expected one of {}.", (Object)this.name, (Object)configValue, (Object)this.possibleValuesAsString());
        }
        return configValue;
    }

    @Override
    public String toString() {
        return "EnumPlatformCondition{name='" + this.name + "', possibleValues=" + this.possibleValuesAsString() + "}";
    }

    private String possibleValuesAsString() {
        return this.possibleValues.stream().sorted().collect(Collectors.joining(", ", "[", "]"));
    }
}

