/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ABAPScanner;
import eu.cqse.check.framework.scanner.AbapCdsScanner;
import eu.cqse.check.framework.scanner.AbapDocScanner;
import eu.cqse.check.framework.scanner.AdaScanner;
import eu.cqse.check.framework.scanner.CPPToken;
import eu.cqse.check.framework.scanner.CSScanner;
import eu.cqse.check.framework.scanner.CToken;
import eu.cqse.check.framework.scanner.CobolScanner;
import eu.cqse.check.framework.scanner.CppAndObjectiveCScannerBase;
import eu.cqse.check.framework.scanner.CppMsCliToken;
import eu.cqse.check.framework.scanner.DartScanner;
import eu.cqse.check.framework.scanner.DelphiScanner;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ESQLScanner;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.EmptyTokenStreamScanner;
import eu.cqse.check.framework.scanner.FortranScanner;
import eu.cqse.check.framework.scanner.GoScanner;
import eu.cqse.check.framework.scanner.GosuScanner;
import eu.cqse.check.framework.scanner.GroovyScanner;
import eu.cqse.check.framework.scanner.HanaSQLScriptScanner;
import eu.cqse.check.framework.scanner.ILenientScanner;
import eu.cqse.check.framework.scanner.IScanner;
import eu.cqse.check.framework.scanner.Iec61131Scanner;
import eu.cqse.check.framework.scanner.JavaDocScanner;
import eu.cqse.check.framework.scanner.JavaScanner;
import eu.cqse.check.framework.scanner.JavaScriptScanner;
import eu.cqse.check.framework.scanner.KotlinScanner;
import eu.cqse.check.framework.scanner.LineScanner;
import eu.cqse.check.framework.scanner.MatlabScanner;
import eu.cqse.check.framework.scanner.NLIssueToken;
import eu.cqse.check.framework.scanner.NLRequirementToken;
import eu.cqse.check.framework.scanner.NLTestToken;
import eu.cqse.check.framework.scanner.OCamlScanner;
import eu.cqse.check.framework.scanner.OScriptScanner;
import eu.cqse.check.framework.scanner.ObjectiveCToken;
import eu.cqse.check.framework.scanner.ObjectiveCppToken;
import eu.cqse.check.framework.scanner.OpenCLScanner;
import eu.cqse.check.framework.scanner.PHPScanner;
import eu.cqse.check.framework.scanner.PLSQLScanner;
import eu.cqse.check.framework.scanner.PowershellScanner;
import eu.cqse.check.framework.scanner.PythonScanner;
import eu.cqse.check.framework.scanner.RustScanner;
import eu.cqse.check.framework.scanner.StrictScanner;
import eu.cqse.check.framework.scanner.SwiftScanner;
import eu.cqse.check.framework.scanner.TSQLScanner;
import eu.cqse.check.framework.scanner.TextScanner;
import eu.cqse.check.framework.scanner.Token;
import eu.cqse.check.framework.scanner.TomlScanner;
import eu.cqse.check.framework.scanner.VBScanner;
import eu.cqse.check.framework.scanner.XMLScanner;
import eu.cqse.check.framework.scanner.XtendScanner;
import eu.cqse.check.framework.util.tokens.WiaTokenUtils;
import java.io.Reader;
import java.io.StringReader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ScannerFactory {
    private ScannerFactory() {
    }

    public static IScanner newScanner(ELanguage language, String input, String originId) {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, input, originId));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, String input, String originId) {
        return ScannerFactory.newLenientScanner(language, new StringReader(input), originId);
    }

    public static IScanner newScanner(ELanguage language, Reader reader, String originId) {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, reader, originId));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, Reader reader, @Nullable String originId) {
        switch (language) {
            case JAVA: {
                return new JavaScanner(reader, originId);
            }
            case CS: {
                return new CSScanner(reader, originId);
            }
            case C: {
                return ScannerFactory.newCScanner(reader, originId);
            }
            case CPP: {
                return ScannerFactory.newCppScanner(reader, originId);
            }
            case CPP_MS_CLI: {
                return ScannerFactory.newMsCppCliScanner(reader, originId);
            }
            case VB: {
                return new VBScanner(reader, originId);
            }
            case COBOL: {
                return new CobolScanner(reader, originId);
            }
            case ABAP: {
                return new ABAPScanner(reader, originId);
            }
            case ADA: {
                return new AdaScanner(reader, originId);
            }
            case NL_REQUIREMENTS: {
                return new TomlScanner<NLRequirementToken>(reader, originId, ScannerFactory.translateTextEscapes(NLRequirementToken::new));
            }
            case NL_TESTS: {
                return new TomlScanner<NLTestToken>(reader, originId, ScannerFactory.translateTextEscapes(NLTestToken::new));
            }
            case NL_ISSUES: {
                return new TomlScanner<NLIssueToken>(reader, originId, ScannerFactory.translateTextEscapes(NLIssueToken::new));
            }
            case TEXT: 
            case ABAP_DDIC: {
                return new TextScanner(reader, originId);
            }
            case ABAP_CDS: {
                return new AbapCdsScanner(reader, originId);
            }
            case XML: 
            case HANA_VIEW: {
                return new XMLScanner(reader, originId);
            }
            case PLSQL: {
                return new PLSQLScanner(reader, originId);
            }
            case PYTHON: {
                return new PythonScanner(reader, originId);
            }
            case TSQL: {
                return new TSQLScanner(reader, originId);
            }
            case MATLAB: {
                return new MatlabScanner(reader, originId);
            }
            case PHP: {
                return new PHPScanner(reader, originId);
            }
            case JAVASCRIPT: {
                return new JavaScriptScanner(reader, originId);
            }
            case LINE: 
            case KUBERNETES: {
                return new LineScanner(reader, originId);
            }
            case DELPHI: {
                return new DelphiScanner(reader, originId);
            }
            case IEC61131: {
                return new Iec61131Scanner(reader, originId);
            }
            case FORTRAN: {
                return new FortranScanner(reader, originId);
            }
            case XTEND: {
                return new XtendScanner(reader, originId);
            }
            case OCAML: {
                return new OCamlScanner(reader, originId);
            }
            case SWIFT: {
                return new SwiftScanner(reader, originId);
            }
            case GROOVY: {
                return new GroovyScanner(reader, originId);
            }
            case SQLSCRIPT: {
                return new HanaSQLScriptScanner(reader, originId);
            }
            case OPEN_CL: {
                return new OpenCLScanner(reader, originId);
            }
            case RUST: {
                return new RustScanner(reader, originId);
            }
            case GOSU: {
                return new GosuScanner(reader, originId);
            }
            case OSCRIPT: {
                return new OScriptScanner(reader, originId);
            }
            case KOTLIN: {
                return new KotlinScanner(reader, originId);
            }
            case JAVADOC: {
                return new JavaDocScanner(reader, originId);
            }
            case ABAPDOC: {
                return new AbapDocScanner(reader, originId);
            }
            case OBJECTIVE_C: {
                return ScannerFactory.newObjectiveCScanner(reader, originId);
            }
            case OBJECTIVE_CPP: {
                return ScannerFactory.newObjectiveCppScanner(reader, originId);
            }
            case GO: {
                return new GoScanner(reader, originId);
            }
            case SIMULINK: {
                return new EmptyTokenStreamScanner(language, originId);
            }
            case POWERSHELL: {
                return new PowershellScanner(reader, originId);
            }
            case ESQL: {
                return new ESQLScanner(reader, originId);
            }
            case DART: {
                return new DartScanner(reader, originId);
            }
        }
        throw new IllegalArgumentException("Language '" + String.valueOf(language) + "' not supported.");
    }

    private static @NonNull CppAndObjectiveCScannerBase<CPPToken> newCppScanner(Reader reader, String originId) {
        return new CppAndObjectiveCScannerBase<CPPToken>(reader, originId){

            @Override
            protected CPPToken token(ETokenType type, long offset, int lineNumber, String text) {
                return new CPPToken(type, offset, lineNumber, text, this.originId);
            }

            @Override
            protected boolean supportsObjectiveCKeywords() {
                return false;
            }

            @Override
            protected boolean supportsCppKeywords() {
                return true;
            }

            @Override
            protected boolean supportsMsCliKeywords() {
                return false;
            }

            @Override
            protected boolean supportCKeywords() {
                return false;
            }
        };
    }

    private static @NonNull CppAndObjectiveCScannerBase<CppMsCliToken> newMsCppCliScanner(Reader reader, String originId) {
        return new CppAndObjectiveCScannerBase<CppMsCliToken>(reader, originId){

            @Override
            protected CppMsCliToken token(ETokenType type, long offset, int lineNumber, String text) {
                return new CppMsCliToken(type, offset, lineNumber, text, this.originId);
            }

            @Override
            protected boolean supportsObjectiveCKeywords() {
                return false;
            }

            @Override
            protected boolean supportsCppKeywords() {
                return true;
            }

            @Override
            protected boolean supportsMsCliKeywords() {
                return true;
            }

            @Override
            protected boolean supportCKeywords() {
                return false;
            }
        };
    }

    private static @NonNull CppAndObjectiveCScannerBase<CToken> newCScanner(Reader reader, String originId) {
        return new CppAndObjectiveCScannerBase<CToken>(reader, originId){

            @Override
            protected CToken token(ETokenType type, long offset, int lineNumber, String text) {
                return new CToken(type, offset, lineNumber, text, this.originId);
            }

            @Override
            protected boolean supportsObjectiveCKeywords() {
                return false;
            }

            @Override
            protected boolean supportsCppKeywords() {
                return false;
            }

            @Override
            protected boolean supportsMsCliKeywords() {
                return false;
            }

            @Override
            protected boolean supportCKeywords() {
                return true;
            }
        };
    }

    private static @NonNull CppAndObjectiveCScannerBase<ObjectiveCToken> newObjectiveCScanner(Reader reader, String originId) {
        return new CppAndObjectiveCScannerBase<ObjectiveCToken>(reader, originId){

            @Override
            protected ObjectiveCToken token(ETokenType type, long offset, int lineNumber, String text) {
                return new ObjectiveCToken(type, offset, lineNumber, text, this.originId);
            }

            @Override
            protected boolean supportsObjectiveCKeywords() {
                return true;
            }

            @Override
            protected boolean supportsCppKeywords() {
                return false;
            }

            @Override
            protected boolean supportsMsCliKeywords() {
                return false;
            }

            @Override
            protected boolean supportCKeywords() {
                return false;
            }
        };
    }

    private static @NonNull CppAndObjectiveCScannerBase<ObjectiveCppToken> newObjectiveCppScanner(Reader reader, String originId) {
        return new CppAndObjectiveCScannerBase<ObjectiveCppToken>(reader, originId){

            @Override
            protected ObjectiveCppToken token(ETokenType type, long offset, int lineNumber, String text) {
                return new ObjectiveCppToken(type, offset, lineNumber, text, this.originId);
            }

            @Override
            protected boolean supportsObjectiveCKeywords() {
                return true;
            }

            @Override
            protected boolean supportsCppKeywords() {
                return true;
            }

            @Override
            protected boolean supportsMsCliKeywords() {
                return false;
            }

            @Override
            protected boolean supportCKeywords() {
                return false;
            }
        };
    }

    private static <T extends Token> TomlScanner.TokenFactory<T> translateTextEscapes(TomlScanner.TokenFactory<T> delegate) {
        return (type, offset, lineNumber, text, originId) -> {
            if (type == ETokenType.STRING_LITERAL && text.startsWith("\"")) {
                text = WiaTokenUtils.translateTomlEscapes(text);
            }
            return delegate.createToken(type, offset, lineNumber, text, originId);
        };
    }

    public static IScanner strict(ILenientScanner scanner) {
        return new StrictScanner(scanner);
    }
}

