/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PreprocessedTokenStreamUtils {
    public static boolean containsMacroExpandedContent(@NonNull List<IToken> tokens) {
        return tokens.stream().anyMatch(PreprocessedTokenStreamUtils::isTokenMacroExpanded);
    }

    public static boolean isTokenMacroExpanded(@NonNull IToken token) {
        return "##macro##".equals(token.getOriginId());
    }

    public static boolean firstTokenOfTypeIsFromMacro(@NonNull List<IToken> tokens, Set<ETokenType> tokenTypes) {
        int position = TokenStreamUtils.firstTokenMatching(tokens, 0, tokens.size(), ITokenMatcher.anyOfType(tokenTypes));
        if (position < 0) {
            return false;
        }
        return PreprocessedTokenStreamUtils.isTokenMacroExpanded(tokens.get(position));
    }

    public static List<IToken> mapTokensToUnpreprocessed(int startTokenIndex, int endTokenIndex, List<IToken> preprocessedTokens, List<IToken> unpreprocessedTokens) {
        if (CollectionUtils.isNullOrEmpty(preprocessedTokens) || CollectionUtils.isNullOrEmpty(unpreprocessedTokens)) {
            return CollectionUtils.emptyList();
        }
        Preconditions.checkElementIndex((int)startTokenIndex, (int)preprocessedTokens.size(), (String)"Start token index is out of bounds.");
        Preconditions.checkPositionIndex((int)endTokenIndex, (int)preprocessedTokens.size(), (String)"End token index is out of bounds.");
        int unpreprocessedStartTokenIndex = TokenStreamUtils.indexOfByOffset(unpreprocessedTokens, preprocessedTokens.get(startTokenIndex).getOffset());
        int unpreprocessedEndTokenIndex = TokenStreamUtils.indexOfByOffset(unpreprocessedTokens, preprocessedTokens.get(endTokenIndex - 1).getOffset()) + 1;
        if (unpreprocessedStartTokenIndex == -1 || unpreprocessedEndTokenIndex == -1 || unpreprocessedStartTokenIndex > unpreprocessedEndTokenIndex) {
            throw new IndexOutOfBoundsException(String.format("Could not map between preprocessed and un-preprocessed tokens: startIndex: %d -> %d, endIndex: %d -> %d", startTokenIndex, unpreprocessedStartTokenIndex, endTokenIndex, unpreprocessedEndTokenIndex));
        }
        if (unpreprocessedStartTokenIndex == unpreprocessedEndTokenIndex) {
            return unpreprocessedTokens.subList(unpreprocessedStartTokenIndex, unpreprocessedEndTokenIndex + 1);
        }
        return unpreprocessedTokens.subList(unpreprocessedStartTokenIndex, unpreprocessedEndTokenIndex);
    }

    public static boolean areTokensAffectedByPreprocessing(int startTokenIndex, int endTokenIndex, List<IToken> preprocessedTokens, List<IToken> unpreprocessedTokens) {
        List<IToken> unpreprocessedContent = PreprocessedTokenStreamUtils.mapTokensToUnpreprocessed(startTokenIndex, endTokenIndex, preprocessedTokens, unpreprocessedTokens);
        if (CollectionUtils.isNullOrEmpty(unpreprocessedContent)) {
            return false;
        }
        List<IToken> contentAfterPreprocessing = preprocessedTokens.subList(startTokenIndex, endTokenIndex);
        if (contentAfterPreprocessing.size() != unpreprocessedContent.size()) {
            return true;
        }
        for (int i = 0; i < unpreprocessedContent.size(); ++i) {
            IToken before = unpreprocessedContent.get(i);
            IToken after = contentAfterPreprocessing.get(i);
            if (before.getType() == after.getType() && before.getText().equals(after.getText())) continue;
            return true;
        }
        return false;
    }

    private PreprocessedTokenStreamUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

