/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.abap.AbapShallowParser;
import java.util.EnumSet;
import java.util.List;

public class ModuleBlockStartRecognizer
extends RecognizerBase<AbapShallowParser.EAbapParserStates> {
    @Override
    protected int matchesLocally(ParserState<AbapShallowParser.EAbapParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (tokens.size() < startOffset + 3) {
            return -1;
        }
        if (tokens.get(startOffset).getType() != ETokenType.MODULE) {
            return -1;
        }
        if (!EnumSet.of(ETokenType.DOT, ETokenType.INPUT, ETokenType.OUTPUT).contains(tokens.get(startOffset + 2).getType())) {
            return -1;
        }
        int endModuleIndex = TokenStreamUtils.firstTokenMatching(tokens, startOffset, (ITokenMatcher)ETokenType.ENDMODULE);
        if (endModuleIndex == -1) {
            return -1;
        }
        int moduleIndex = TokenStreamUtils.firstTokenMatching(tokens, startOffset + 1, (ITokenMatcher)ETokenType.MODULE);
        if (moduleIndex != -1 && moduleIndex < endModuleIndex) {
            return -1;
        }
        return startOffset;
    }
}

