/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import eu.cqse.check.framework.core.xpath.DocumentRootShallowEntity;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.shallowparser.util.TrivialMethodUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class EntitySelectionPredicates {
    private static final EnumSet<ETokenType> CPP_VISIBILITY_MODIFIERS = EnumSet.of(ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED);
    private static final EnumSet<ETokenType> SWIFT_VISIBILITY_MODIFIERS = EnumSet.of(ETokenType.OPEN, new ETokenType[]{ETokenType.PUBLIC, ETokenType.INTERNAL, ETokenType.PRIVATE, ETokenType.FILEPRIVATE, ETokenType.STATIC});
    private static final TokenPattern EXTENDS_CLASS = LanguageFeatureParser.JAVA.classExtendsPattern().sequence(ETokenType.IDENTIFIER, new TokenPattern().repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(0);

    public static Predicate<ShallowEntity> language(String languageName) {
        ELanguage language = (ELanguage)EnumUtils.valueOfIgnoreCase(ELanguage.class, (String)languageName);
        if (language == null) {
            return entity -> false;
        }
        return EntitySelectionPredicates.hasLanguage(language);
    }

    private static Predicate<ShallowEntity> hasLanguage(ELanguage language) {
        return entity -> language == EntitySelectionPredicates.getLanguage(entity);
    }

    public static Predicate<ShallowEntity> module() {
        return EntitySelectionPredicates.typePredicate(EShallowEntityType.MODULE);
    }

    public static Predicate<ShallowEntity> type() {
        return EntitySelectionPredicates.typePredicate(EShallowEntityType.TYPE).and(entity -> !entity.getSubtype().equals("typedef")).and(entity -> EntitySelectionPredicates.getLanguage(entity) != ELanguage.ABAP || "class definition".equals(entity.getSubtype()) || "interface definition".equals(entity.getSubtype()));
    }

    public static Predicate<ShallowEntity> method() {
        return entity -> !(entity.getType() != EShallowEntityType.METHOD || entity.getParent() != null && entity.getParent().getType() == EShallowEntityType.ATTRIBUTE || EntitySelectionPredicates.isJavaScriptLocalNamedFunction(entity) || EntitySelectionPredicates.getLanguage(entity) == ELanguage.ABAP && !EntitySelectionPredicates.isAbapMethod(entity));
    }

    private static boolean isAbapMethod(ShallowEntity entity) {
        String subtype = entity.getSubtype();
        return "function".equals(subtype) || "form".equals(subtype) || "method declaration".equals(subtype);
    }

    private static boolean isJavaScriptLocalNamedFunction(ShallowEntity entity) {
        return EntitySelectionPredicates.getLanguage(entity) == ELanguage.JAVASCRIPT && entity.getSubtype().equals("named function") && entity.getParent() != null && entity.getParent().getType() == EShallowEntityType.STATEMENT;
    }

    public static Predicate<ShallowEntity> declaration() {
        return entity -> {
            if (entity.getSubtype().endsWith("declaration")) {
                return true;
            }
            ELanguage language = EntitySelectionPredicates.getLanguage(entity);
            if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language)) {
                ShallowEntity parent = entity.getParent();
                return parent != null && parent.getType() == EShallowEntityType.TYPE;
            }
            return false;
        };
    }

    public static Predicate<ShallowEntity> internal() {
        return EntitySelectionPredicates.csInternal().or(EntitySelectionPredicates.swiftInternal());
    }

    private static Predicate<ShallowEntity> csInternal() {
        return EntitySelectionPredicates::isCsInternal;
    }

    private static boolean isCsInternal(ShallowEntity entity) {
        if (EntitySelectionPredicates.getLanguage(entity) != ELanguage.CS) {
            return false;
        }
        switch (entity.getType()) {
            case TYPE: 
            case METHOD: 
            case ATTRIBUTE: {
                break;
            }
            default: {
                return false;
            }
        }
        if (EntitySelectionPredicates.modifierPredicate(ETokenType.PRIVATE).test(entity)) {
            return false;
        }
        ShallowEntity parent = entity.getParent();
        if (parent != null && EntitySelectionPredicates.isCsInternal(parent)) {
            return true;
        }
        if (EntitySelectionPredicates.modifierPredicate(ETokenType.INTERNAL).test(entity)) {
            return true;
        }
        return !EntitySelectionPredicates.hasVisibilityModifiers(entity);
    }

    private static Predicate<ShallowEntity> swiftInternal() {
        return EntitySelectionPredicates.hasLanguage(ELanguage.SWIFT).and(EntitySelectionPredicates.modifierPredicate(ETokenType.INTERNAL).or(EntitySelectionPredicates::isSwiftDefaultVisibility));
    }

    public static Predicate<ShallowEntity> attribute() {
        return EntitySelectionPredicates.typePredicate(EShallowEntityType.ATTRIBUTE).and(Predicate.not(EntitySelectionPredicates::isAbapReportParameter));
    }

    private static boolean isAbapReportParameter(ShallowEntity shallowEntity) {
        return shallowEntity.getType() == EShallowEntityType.ATTRIBUTE && "parameters".equals(shallowEntity.getSubtype());
    }

    public static Predicate<ShallowEntity> property() {
        return EntitySelectionPredicates::isProperty;
    }

    private static boolean isProperty(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        for (ShallowEntity child : entity.getChildren()) {
            if (child.getType() == EShallowEntityType.METHOD) continue;
            return false;
        }
        return !entity.getChildren().isEmpty();
    }

    public static Predicate<ShallowEntity> statement() {
        return EntitySelectionPredicates.typePredicate(EShallowEntityType.STATEMENT);
    }

    public static Predicate<ShallowEntity> meta() {
        return EntitySelectionPredicates.typePredicate(EShallowEntityType.META);
    }

    private static Predicate<ShallowEntity> typePredicate(EShallowEntityType type) {
        return entity -> entity.getType() == type;
    }

    public static Predicate<ShallowEntity> selectPublic() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.PUBLIC).and(EntitySelectionPredicates.internal().negate()).or(EntitySelectionPredicates::isInterfaceMethod).or(EntitySelectionPredicates::isJavaScriptInterface).or(EntitySelectionPredicates::isAbapPublicEntity).or(EntitySelectionPredicates::isKotlinDefaultVisibility).and(EntitySelectionPredicates::isNotTypeScriptConstructor);
    }

    private static boolean isKotlinDefaultVisibility(ShallowEntity entity) {
        return EntitySelectionPredicates.getLanguage(entity) == ELanguage.KOTLIN && !EntitySelectionPredicates.modifierPredicate(ETokenType.INTERNAL).or(EntitySelectionPredicates.modifierPredicate(ETokenType.PROTECTED)).or(EntitySelectionPredicates.modifierPredicate(ETokenType.PRIVATE)).test(entity);
    }

    private static boolean isJavaScriptInterface(ShallowEntity entity) {
        return EntitySelectionPredicates.getLanguage(entity) == ELanguage.JAVASCRIPT && entity.getType() == EShallowEntityType.TYPE && EntitySelectionPredicates.modifierPredicate(ETokenType.INTERFACE).test(entity);
    }

    private static boolean isAbapPrivateEntity(ShallowEntity entity) {
        if (EntitySelectionPredicates.getLanguage(entity) != ELanguage.ABAP) {
            return false;
        }
        if (entity.getType() == EShallowEntityType.TYPE && !TokenStreamUtils.containsAny((List<IToken>)entity.ownStartTokens(), ETokenType.PROTECTED, ETokenType.PUBLIC)) {
            return true;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        return EntitySelectionPredicates.searchAbapVisibilityEntityChild(entity, "private");
    }

    private static boolean isAbapProtectedEntity(ShallowEntity entity) {
        if (EntitySelectionPredicates.getLanguage(entity) != ELanguage.ABAP) {
            return false;
        }
        if (entity.getType() == EShallowEntityType.TYPE && TokenStreamUtils.contains((List<IToken>)entity.ownStartTokens(), ETokenType.PROTECTED)) {
            return true;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        return EntitySelectionPredicates.searchAbapVisibilityEntityChild(entity, "protected");
    }

    private static boolean isAbapPublicEntity(ShallowEntity entity) {
        if (EntitySelectionPredicates.getLanguage(entity) != ELanguage.ABAP) {
            return false;
        }
        if (entity.getType() == EShallowEntityType.METHOD && "form".equals(entity.getSubtype())) {
            return false;
        }
        if (entity.getType() == EShallowEntityType.METHOD && "function".equals(entity.getSubtype())) {
            return true;
        }
        if (entity.getType() == EShallowEntityType.TYPE && TokenStreamUtils.contains((List<IToken>)entity.ownStartTokens(), ETokenType.PUBLIC)) {
            return true;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getType() == EShallowEntityType.TYPE && "interface definition".equals(parent.getSubtype())) {
            return true;
        }
        return EntitySelectionPredicates.searchAbapVisibilityEntityChild(entity, "public");
    }

    private static boolean searchAbapVisibilityEntityChild(ShallowEntity entity, String visibility) {
        UnmodifiableList siblings = Objects.requireNonNull(entity.getParent()).getChildren();
        for (int i = siblings.indexOf((Object)entity) - 1; i >= 0; --i) {
            if (EntitySelectionPredicates.isAbapVisibilityMetaEntity((ShallowEntity)siblings.get(i), visibility)) {
                return true;
            }
            if (!EntitySelectionPredicates.isAbapVisibilityMetaEntity((ShallowEntity)siblings.get(i))) continue;
            return false;
        }
        return false;
    }

    private static boolean isAbapVisibilityMetaEntity(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && "Visibility".equals(entity.getSubtype());
    }

    private static boolean isAbapVisibilityMetaEntity(ShallowEntity entity, String visibility) {
        return entity.getType() == EShallowEntityType.META && "Visibility".equals(entity.getSubtype()) && visibility.equals(entity.getName());
    }

    private static boolean isInterfaceMethod(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        return entity.getType() == EShallowEntityType.METHOD && parent != null && parent.getType() == EShallowEntityType.TYPE && EntitySelectionPredicates.modifierPredicate(ETokenType.INTERFACE).test(parent);
    }

    public static Predicate<ShallowEntity> isAbstract() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.ABSTRACT).or(EntitySelectionPredicates::isInterfaceMethod);
    }

    public static Predicate<ShallowEntity> selectProtected() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.PROTECTED).and(EntitySelectionPredicates::isNotTypeScriptConstructor).or(EntitySelectionPredicates::isAbapProtectedEntity);
    }

    public static Predicate<ShallowEntity> selectOverride() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.OVERRIDE);
    }

    public static Predicate<ShallowEntity> selectRedefinition() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.REDEFINITION);
    }

    public static Predicate<ShallowEntity> selectPrivate() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.PRIVATE).and(EntitySelectionPredicates::isNotTypeScriptConstructor).or(EntitySelectionPredicates::isAbapPrivateEntity);
    }

    public static Predicate<ShallowEntity> selectFileprivate() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.FILEPRIVATE);
    }

    private static boolean isSwiftDefaultVisibility(ShallowEntity entity) {
        return EntitySelectionPredicates.getLanguage(entity) == ELanguage.SWIFT && !EntitySelectionPredicates.modifierPredicate(ETokenType.OPEN).or(EntitySelectionPredicates.modifierPredicate(ETokenType.PUBLIC)).or(EntitySelectionPredicates.modifierPredicate(ETokenType.PRIVATE).or(EntitySelectionPredicates.modifierPredicate(ETokenType.FILEPRIVATE))).test(entity);
    }

    private static boolean isNotTypeScriptConstructor(ShallowEntity entity) {
        if (EntitySelectionPredicates.getLanguage(entity) == ELanguage.JAVASCRIPT) {
            return !"constructor".equals(entity.getSubtype());
        }
        return true;
    }

    public static Predicate<ShallowEntity> selectDefault() {
        return element -> {
            if (EntitySelectionPredicates.getLanguage(element) == ELanguage.JAVASCRIPT) {
                return EntitySelectionPredicates.isTypeScriptDefault(element);
            }
            return !EntitySelectionPredicates.hasVisibilityModifiers(element);
        };
    }

    private static boolean hasVisibilityModifiers(ShallowEntity element) {
        UnmodifiableList tokens = element.ownStartTokens();
        return TokenStreamUtils.containsAny((List<IToken>)tokens, 0, tokens.size(), ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.PRIVATE);
    }

    private static boolean isTypeScriptDefault(ShallowEntity entity) {
        UnmodifiableList tokens;
        boolean isConstructor;
        if (EntitySelectionPredicates.getLanguage(entity) != ELanguage.JAVASCRIPT) {
            return false;
        }
        boolean bl = isConstructor = entity.getType() == EShallowEntityType.METHOD && "constructor".equals(entity.getSubtype());
        if (isConstructor && !(tokens = entity.ownStartTokens()).isEmpty() && ((IToken)tokens.get(0)).getText().equals("constructor")) {
            return true;
        }
        if (EntitySelectionPredicates.hasVisibilityModifiers(entity)) {
            return false;
        }
        if (entity.getType() == EShallowEntityType.METHOD && "lambda".equals(entity.getSubtype())) {
            return false;
        }
        return entity.getType() == EShallowEntityType.TYPE && !EntitySelectionPredicates.isTopLevelEntity(entity) || entity.getType() == EShallowEntityType.METHOD && !EntitySelectionPredicates.isTopLevelEntity(entity) || entity.getType() == EShallowEntityType.ATTRIBUTE;
    }

    private static boolean isTopLevelEntity(ShallowEntity entity) {
        return entity.getParent() == null || entity.getParent() instanceof DocumentRootShallowEntity;
    }

    public static Predicate<ShallowEntity> selectFinal() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.FINAL);
    }

    public static Predicate<ShallowEntity> selectStatic() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.STATIC);
    }

    public static Predicate<ShallowEntity> export() {
        return EntitySelectionPredicates.modifierPredicate(ETokenType.EXPORT).or(EntitySelectionPredicates::isTypeScriptSeparatelyExported);
    }

    private static boolean isTypeScriptSeparatelyExported(ShallowEntity entity) {
        if (entity.getName() == null) {
            return false;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null || !"document-root".equals(parent.getSubtype())) {
            return false;
        }
        UnmodifiableList children = parent.getChildren();
        List metaEntities = CollectionUtils.filter((Collection)ShallowEntityTraversalUtils.listEntitiesOfType((Collection)children, (EShallowEntityType)EShallowEntityType.META), metaEntity -> metaEntity.getSubtype().equals("export"));
        for (ShallowEntity metaEntity2 : metaEntities) {
            UnmodifiableList tokens = metaEntity2.ownStartTokens();
            TokenPattern pattern = new TokenPattern();
            pattern.alternative(ETokenType.LBRACE, ETokenType.COMMA).sequence(TokenPattern.text(entity.getName()));
            if (!pattern.matchesAnywhere((List<IToken>)tokens)) continue;
            return true;
        }
        return false;
    }

    private static Predicate<ShallowEntity> modifierPredicate(ETokenType modifier) {
        return entity -> EntitySelectionPredicates.handleEntityWithModifier(modifier, entity);
    }

    private static boolean handleEntityWithModifier(ETokenType modifier, ShallowEntity element) {
        ELanguage language = EntitySelectionPredicates.getLanguage(element);
        if (ELanguage.SWIFT == language && EShallowEntityType.ATTRIBUTE == element.getType()) {
            return EntitySelectionPredicates.handleSwiftAttribute(element, modifier);
        }
        if (TokenStreamUtils.firstTokenMatching((List<IToken>)element.ownStartTokens(), (ITokenMatcher)modifier) != -1) {
            return true;
        }
        if ((ELanguage.CPP == language || ELanguage.CPP_MS_CLI == language) && CPP_VISIBILITY_MODIFIERS.contains(modifier)) {
            return EntitySelectionPredicates.hasCppVisibilityModifier(element, modifier);
        }
        return false;
    }

    private static boolean handleSwiftAttribute(ShallowEntity element, ETokenType modifier) {
        ArrayList<IToken> tokens = new ArrayList<IToken>((Collection<IToken>)element.includedTokens());
        for (ETokenType visibilityModifier : SWIFT_VISIBILITY_MODIFIERS) {
            TokenStreamUtils.removeAllOfSequence(tokens, visibilityModifier, ETokenType.LPAREN, ETokenType.SET, ETokenType.RPAREN);
        }
        return TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)modifier) != -1;
    }

    private static ELanguage getLanguage(ShallowEntity entity) {
        return ShallowParsingUtils.getLanguage(entity);
    }

    private static String getUniformPath(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (tokens.isEmpty()) {
            return null;
        }
        return Objects.requireNonNull((IToken)CollectionUtils.getAny((Iterable)tokens)).getOriginId();
    }

    private static boolean hasCppVisibilityModifier(ShallowEntity entity, ETokenType modifier) {
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        UnmodifiableList siblings = parent.getChildren();
        for (int i = siblings.indexOf((Object)entity) - 1; i >= 0; --i) {
            ShallowEntity sibling = (ShallowEntity)siblings.get(i);
            if (!EntitySelectionPredicates.isCppVisibilityModifier(sibling)) continue;
            return TokenStreamUtils.containsAny((List<IToken>)sibling.ownStartTokens(), modifier);
        }
        if (parent.getType() == EShallowEntityType.TYPE) {
            if ("struct".equals(parent.getSubtype())) {
                return ETokenType.PUBLIC == modifier;
            }
            return ETokenType.PRIVATE == modifier;
        }
        return false;
    }

    private static boolean isCppVisibilityModifier(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && TokenStreamUtils.containsAny((List<IToken>)entity.ownStartTokens(), CPP_VISIBILITY_MODIFIERS);
    }

    public static Predicate<ShallowEntity> primitive() {
        return entity -> entity.getChildren().isEmpty();
    }

    public static Predicate<ShallowEntity> subtype(String subtype) {
        return entity -> subtype.equals(entity.getSubtype());
    }

    public static Predicate<ShallowEntity> typeSubtype(String subtype) {
        return entity -> {
            ShallowEntity parent = entity.getParent();
            return parent != null && EntitySelectionPredicates.type().test(parent) && parent.getSubtype().equals(subtype);
        };
    }

    public static Predicate<ShallowEntity> typeExported() {
        return entity -> {
            ShallowEntity parent = entity.getParent();
            return parent != null && EntitySelectionPredicates.type().test(parent) && EntitySelectionPredicates.export().test(parent);
        };
    }

    public static Predicate<ShallowEntity> extendsType(String className) {
        return entity -> Optional.ofNullable(EXTENDS_CLASS.findFirstMatch((List<IToken>)entity.ownStartTokens())).map(match -> match.groupString(0).equals(className)).orElse(false);
    }

    public static Predicate<ShallowEntity> name(String name) {
        return entity -> name.equals(entity.getName());
    }

    public static Predicate<ShallowEntity> nameRegex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        return entity -> entity.getName() != null && pattern.matcher(entity.getName()).matches();
    }

    public static Predicate<ShallowEntity> fileRegex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        return entity -> {
            String uniformPath = EntitySelectionPredicates.getUniformPath(entity);
            if (uniformPath == null) {
                return false;
            }
            return pattern.matcher(uniformPath).matches();
        };
    }

    public static Predicate<ShallowEntity> annotated(String annotationName) {
        String normalizedAnnotationName = StringUtils.stripPrefix((String)annotationName, (String)"@");
        return entity -> EntitySelectionPredicates.isAnnotated(normalizedAnnotationName, annotationName, entity);
    }

    private static boolean isAnnotated(String normalizedAnnotationName, String annotationName, ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        if (EntitySelectionPredicates.getLanguage(entity) == ELanguage.JAVASCRIPT) {
            return EntitySelectionPredicates.hasAnnotation(annotationName, entity, (List<ShallowEntity>)parent.getChildren(), "decorator");
        }
        if (EntitySelectionPredicates.getLanguage(entity) == ELanguage.CS) {
            return EntitySelectionPredicates.hasAnnotation(annotationName, entity, (List<ShallowEntity>)parent.getChildren(), "attribute annotation");
        }
        return EntitySelectionPredicates.hasAnnotation(normalizedAnnotationName, entity, (List<ShallowEntity>)parent.getChildren(), "annotation");
    }

    private static boolean hasAnnotation(String annotationName, ShallowEntity entity, List<ShallowEntity> children, String subTypeNameToCheck) {
        int index = children.indexOf(entity);
        --index;
        while (index >= 0 && children.get(index).getType() == EShallowEntityType.META) {
            ShallowEntity metaEntity = children.get(index);
            if (subTypeNameToCheck.equals(metaEntity.getSubtype()) && annotationName.equalsIgnoreCase(metaEntity.getName())) {
                return true;
            }
            --index;
        }
        return false;
    }

    public static Predicate<ShallowEntity> simpleGetter() {
        return ((Predicate<ShallowEntity>)TrivialMethodUtils::isGetterImplementation).and(EntitySelectionPredicates.isAbstract().negate());
    }

    public static Predicate<ShallowEntity> simpleSetter() {
        return ((Predicate<ShallowEntity>)TrivialMethodUtils::isSetterImplementation).and(EntitySelectionPredicates.isAbstract().negate());
    }

    @Deprecated
    public static Predicate<ShallowEntity> simpleSetterCaseInsensitive() {
        return EntitySelectionPredicates.simpleSetter();
    }

    @Deprecated
    public static Predicate<ShallowEntity> simpleGetterCaseInsensitive() {
        return EntitySelectionPredicates.simpleGetter();
    }

    public static Predicate<ShallowEntity> simpleMethod(String namePrefix) {
        return entity -> EntitySelectionPredicates.isSimpleMethod(entity) && entity.getName() != null && entity.getName().startsWith(namePrefix);
    }

    public static Predicate<ShallowEntity> simpleMethodCaseInsensitive(String namePrefix) {
        return entity -> EntitySelectionPredicates.isSimpleMethod(entity) && entity.getName() != null && entity.getName().toLowerCase().startsWith(namePrefix.toLowerCase());
    }

    private static boolean isSimpleMethod(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && EntitySelectionPredicates.getStatementCount(entity) <= 1;
    }

    private static int getStatementCount(ShallowEntity entity) {
        return ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entity.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT).size();
    }
}

