/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.languages.abap.AbapShallowParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class AbapMethodCallRecognizer {
    private static final String CONV_LITERAL = "CONV";
    private static final String CAST_LITERAL = "CAST";
    private static final ITokenMatcher PARAMETER_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXPORTING, ETokenType.IMPORTING, ETokenType.RECEIVING, ETokenType.CHANGING, ETokenType.EXCEPTIONS, ETokenType.TABLES});
    private static final ITokenMatcher PARAMETER_TERMINATING_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXPORTING, ETokenType.IMPORTING, ETokenType.RECEIVING, ETokenType.CHANGING, ETokenType.EXCEPTIONS, ETokenType.TABLES, ETokenType.DOT, ETokenType.RPAREN});
    private final List<IToken> tokens;
    private int currentPosition = 0;
    private final MethodCallInfo details = new MethodCallInfo();

    private AbapMethodCallRecognizer(List<IToken> tokens) {
        this.tokens = tokens;
    }

    public static Optional<MethodCallInfo> parse(List<IToken> tokens) {
        AbapMethodCallRecognizer recognizer = new AbapMethodCallRecognizer(tokens);
        return recognizer.parseMethodCall();
    }

    public static Optional<MethodCallInfo> parseParameterList(List<IToken> parameterListTokens, String methodName) {
        int parameterStart = TokenStreamUtils.firstTokenMatching(parameterListTokens, (ITokenMatcher)ETokenType.LPAREN);
        if (parameterStart == -1) {
            return Optional.empty();
        }
        MethodCallInfo result = new MethodCallInfo();
        result.methodName = methodName;
        AbapMethodCallRecognizer recognizer = new AbapMethodCallRecognizer(CollectionUtils.subListFrom(parameterListTokens, (int)parameterStart));
        recognizer.currentPosition = 1;
        boolean parsedSuccessful = recognizer.parseParameterDeclarations(result);
        if (parsedSuccessful) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Optional<MethodCallInfo> parseMethodCall() {
        if (this.tokens.isEmpty() || this.tokens.size() < 2) {
            return Optional.empty();
        }
        if (this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.PERFORM)) {
            return this.parsePerformCall(this.tokens);
        }
        return this.parseMethodOrFunctionCall();
    }

    private Optional<MethodCallInfo> parseMethodOrFunctionCall() {
        if (ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ARROW, ETokenType.EQ}).matches(this.tokens.get(this.currentPosition + 1)) && !this.parseAssignee()) {
            return Optional.empty();
        }
        if (TokenStreamUtils.startsWith(this.tokens, ETokenType.CALL, ETokenType.FUNCTION)) {
            this.currentPosition += 2;
            this.details.setFunctionCall(true);
        } else {
            this.skipOptionalTokens(ETokenType.CALL, new ITokenMatcher[]{ETokenType.METHOD});
        }
        if (this.tokens.size() <= this.currentPosition) {
            return Optional.empty();
        }
        if (this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.IDENTIFIER)) {
            if (!this.parseMethodName()) {
                return Optional.empty();
            }
        } else if (this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.CHARACTER_LITERAL)) {
            this.details.methodName = StringUtils.stripSuffix((String)StringUtils.stripPrefix((String)this.tokens.get(this.currentPosition).getText(), (String)"'"), (String)"'");
            ++this.currentPosition;
        } else {
            return Optional.empty();
        }
        if (this.details.methodName.equalsIgnoreCase(CAST_LITERAL) || this.details.methodName.equalsIgnoreCase(CONV_LITERAL)) {
            return Optional.empty();
        }
        int positionBeforeParameters = this.currentPosition;
        if (!this.parseParameters() || this.currentPosition == positionBeforeParameters) {
            return Optional.empty();
        }
        if (!this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.DOT)) {
            return Optional.empty();
        }
        return Optional.of(this.details);
    }

    private boolean advance(int distance) {
        this.currentPosition += distance;
        return this.currentPosition < this.tokens.size();
    }

    private void skipOptionalTokens(ETokenType optionalType, ITokenMatcher ... optionalTypesRest) {
        ITokenMatcher types = optionalType.or(optionalTypesRest);
        while (types.matches(this.tokens.get(this.currentPosition))) {
            if (this.advance(1)) continue;
            return;
        }
    }

    private boolean parseMethodName() {
        if (this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.EQGT)) {
            this.details.methodContainerName = this.tokens.get(this.currentPosition).getText();
            this.details.isStaticCall = true;
            this.details.methodName = this.tokens.get(this.currentPosition + 2).getText();
            return this.advance(3);
        }
        if (this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.ARROW)) {
            this.details.methodContainerName = "";
            this.details.isStaticCall = false;
            while (this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.ARROW)) {
                this.details.methodContainerName = this.details.methodContainerName + this.tokens.get(this.currentPosition).getText();
                if (!this.advance(2)) {
                    return false;
                }
                if (!this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.ARROW)) continue;
                this.details.methodContainerName = this.details.methodContainerName + "->";
            }
            this.details.methodName = this.tokens.get(this.currentPosition).getText();
            return this.advance(1);
        }
        this.details.methodName = this.tokens.get(this.currentPosition).getText();
        return this.advance(1);
    }

    private boolean matchesTokenAt(int position, ITokenMatcher matcher) {
        if (position > this.tokens.size()) {
            return false;
        }
        return matcher.matches(this.tokens.get(position));
    }

    private boolean parseParameters() {
        if (!this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.LPAREN)) {
            return this.parseParameterDeclarations(this.details);
        }
        if (!this.advance(1)) {
            return false;
        }
        if (this.skipMandatoryToken()) {
            return true;
        }
        if (this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.IDENTIFIER) && this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.RPAREN)) {
            this.details.unnamedParameters.add(LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition).getText()));
            return this.advance(2);
        }
        if (this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.EQ)) {
            return this.parseNamedParameters();
        }
        if (!this.parseParameterDeclarations(this.details)) {
            return false;
        }
        return this.skipMandatoryToken();
    }

    private boolean parseNamedParameters() {
        try {
            this.parseParameterListInto(this.details.namedParameters);
        }
        catch (MethodCallParserException e) {
            return false;
        }
        return this.skipMandatoryToken();
    }

    private boolean skipMandatoryToken() {
        return this.matchesTokenAt(this.currentPosition, (ITokenMatcher)ETokenType.RPAREN) && this.advance(1);
    }

    private boolean parseAssignee() {
        Object identifierStart = "";
        while (this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.ARROW)) {
            identifierStart = (String)identifierStart + LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition).getText()) + "->";
            if (this.advance(2)) continue;
            return false;
        }
        if (this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.EQ)) {
            this.details.assignee = (String)identifierStart + LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition).getText());
            return this.advance(2);
        }
        return true;
    }

    private Optional<MethodCallInfo> parsePerformCall(List<IToken> tokens) {
        MethodCallInfo details = new MethodCallInfo();
        details.isFormCall = true;
        if (tokens.isEmpty() || tokens.size() < 2) {
            return Optional.empty();
        }
        int currentPosition = 0;
        if (!this.matchesTokenAt(currentPosition, (ITokenMatcher)ETokenType.PERFORM)) {
            return Optional.empty();
        }
        if (this.isTokenPossibleIdentifierInPerform(++currentPosition)) {
            details.methodName = tokens.get(currentPosition).getText();
            ++currentPosition;
        } else if (this.matchesTokenAt(currentPosition, (ITokenMatcher)ETokenType.LPAREN) && this.isTokenPossibleIdentifierInPerform(currentPosition + 1) && this.matchesTokenAt(currentPosition + 2, (ITokenMatcher)ETokenType.RPAREN)) {
            details.methodName = "(" + tokens.get(currentPosition + 1).getText() + ")";
            currentPosition += 3;
        } else {
            return Optional.empty();
        }
        for (currentPosition = this.skipInProgram(tokens, currentPosition); tokens.size() > currentPosition && !this.matchesTokenAt(currentPosition, (ITokenMatcher)ETokenType.DOT); ++currentPosition) {
            if (ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.USING, ETokenType.CHANGING, ETokenType.IF, ETokenType.FOUND}).matches(tokens.get(currentPosition))) continue;
            details.unnamedParameters.add(LanguageFeatureParser.ABAP.normalizeVariable(tokens.get(currentPosition).getText()));
        }
        if (currentPosition >= tokens.size()) {
            LogManager.getLogger().warn("Could not parse abap method call from {}:{}", (Object)tokens.getFirst().getOriginId(), (Object)(tokens.getFirst().getLineNumber() + 1));
            return Optional.empty();
        }
        if (this.matchesTokenAt(currentPosition, (ITokenMatcher)ETokenType.DOT)) {
            return Optional.of(details);
        }
        return Optional.empty();
    }

    private int skipInProgram(List<IToken> tokens, int currentPosition) {
        if (!this.matchesTokenAt(currentPosition, (ITokenMatcher)ETokenType.IN) || !this.matchesTokenAt(currentPosition + 1, (ITokenMatcher)ETokenType.PROGRAM)) {
            return currentPosition;
        }
        if (this.matchesTokenAt(currentPosition + 2, (ITokenMatcher)ETokenType.LPAREN)) {
            currentPosition = TokenStreamUtils.firstTokenMatching(tokens, currentPosition + 2, (ITokenMatcher)ETokenType.RPAREN) + 1;
            return currentPosition;
        }
        return currentPosition + 3;
    }

    private boolean isTokenPossibleIdentifierInPerform(int position) {
        if (position > this.tokens.size()) {
            return false;
        }
        ITokenMatcher unacceptedTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FORM, ETokenType.USING, ETokenType.CHANGING, ETokenType.TABLES, ETokenType.LIKE, ETokenType.TYPE, ETokenType.IN, ETokenType.PROGRAM, ETokenType.IF, ETokenType.FOUND});
        IToken token = this.tokens.get(position);
        return AbapShallowParser.IDENTIFIER_LIKE.matches(token) && !unacceptedTokens.matches(token);
    }

    private boolean parseParameterDeclarations(MethodCallInfo details) {
        try {
            while (PARAMETER_TOKEN_TYPES.matches(this.tokens.get(this.currentPosition))) {
                if (this.parseParameterDeclarationSection(details)) continue;
                return false;
            }
        }
        catch (MethodCallParserException e) {
            return false;
        }
        return true;
    }

    private boolean parseParameterDeclarationSection(MethodCallInfo details) throws MethodCallParserException {
        ETokenType sectionType = this.tokens.get(this.currentPosition).getType();
        if (!this.advance(1)) {
            return false;
        }
        switch (sectionType) {
            case EXPORTING: {
                this.parseParameterListInto(details.namedParameters);
                break;
            }
            case IMPORTING: {
                this.parseParameterListInto(details.importingParameters);
                break;
            }
            case CHANGING: {
                this.parseParameterListInto(details.changingParameters);
                break;
            }
            case RECEIVING: {
                if (this.parseReceivingParameter(details)) break;
                return false;
            }
            case EXCEPTIONS: {
                this.parseParameterListInto(details.exceptions);
                break;
            }
            case TABLES: {
                this.parseParameterListInto(details.tablesParameters);
                break;
            }
            default: {
                CCSMAssert.fail((String)"List of parameterTokenTypes is not in sync with switch cases.");
            }
        }
        return true;
    }

    private boolean parseReceivingParameter(MethodCallInfo details) throws MethodCallParserException {
        if (!TokenStreamUtils.hasTokenTypeSequence(this.tokens, this.currentPosition, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER)) {
            throw new MethodCallParserException("Did not find pattern \"x = y\" in receiving parameter at position " + this.currentPosition + " .");
        }
        String formalParameterName = LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition).getText());
        String actualParameterReferece = LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition + 2).getText());
        details.namedReturnParameter = new Pair((Object)formalParameterName, (Object)actualParameterReferece);
        return this.advance(3);
    }

    private void parseParameterListInto(Map<String, String> parameterList) throws MethodCallParserException {
        while (!PARAMETER_TOKEN_TYPES.matches(this.tokens.get(this.currentPosition)) && LanguageFeatureParser.ABAP.isPossiblyIdentifier(this.tokens.get(this.currentPosition))) {
            Object actualParameterReference;
            String formalParameterName = LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition).getText());
            if (!this.matchesTokenAt(this.currentPosition + 1, (ITokenMatcher)ETokenType.EQ)) {
                throw new MethodCallParserException("Did not find pattern \"x = y\" in parameter list element at position " + this.currentPosition + " of tokenStream " + String.valueOf(this.tokens) + ".");
            }
            if (this.matchesTokenAt(this.currentPosition + 2, (ITokenMatcher)ETokenType.LT) && this.tokens.get(this.currentPosition + 2).getText().equals("<")) {
                if (!this.matchesTokenAt(this.currentPosition + 4, (ITokenMatcher)ETokenType.GT)) {
                    throw new MethodCallParserException("Could not parse element as actual parameter at " + this.currentPosition + " of tokenStream " + String.valueOf(this.tokens) + ".");
                }
                actualParameterReference = "<" + LanguageFeatureParser.ABAP.normalizeVariable(this.tokens.get(this.currentPosition + 3).getText()) + ">";
                this.currentPosition += 5;
            } else {
                this.currentPosition += 2;
                actualParameterReference = LanguageFeatureParser.ABAP.normalizeVariable(this.scanUntilParameterEnd());
            }
            parameterList.put(formalParameterName, (String)actualParameterReference);
        }
    }

    private String scanUntilParameterEnd() throws MethodCallParserException {
        String actualParameterReference = "";
        int nextParameterTerminatingTokenIndex = TokenStreamUtils.findFirstTopLevel(this.tokens, this.currentPosition, PARAMETER_TERMINATING_TOKENS, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
        int nextEqTokenIndex = TokenStreamUtils.findFirstTopLevel(this.tokens, this.currentPosition, ETokenType.EQ.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"="})}), Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
        if (nextEqTokenIndex == -1 || nextParameterTerminatingTokenIndex < nextEqTokenIndex) {
            actualParameterReference = TokenStreamTextUtils.concatTokenTexts(this.tokens.subList(this.currentPosition, nextParameterTerminatingTokenIndex), " ");
            this.currentPosition = nextParameterTerminatingTokenIndex;
        } else if (nextEqTokenIndex < nextParameterTerminatingTokenIndex && nextParameterTerminatingTokenIndex != -1) {
            actualParameterReference = TokenStreamTextUtils.concatTokenTexts(this.tokens.subList(this.currentPosition, nextEqTokenIndex - 1), " ");
            this.currentPosition = nextEqTokenIndex - 1;
        } else if (nextParameterTerminatingTokenIndex == -1) {
            throw new MethodCallParserException("Did not find closing token of parameter at position " + this.currentPosition + " of tokenStream " + this.tokens.toString() + ".");
        }
        return actualParameterReference;
    }

    public static class MethodCallInfo {
        private String methodName;
        private String methodContainerName;
        private boolean isStaticCall;
        private boolean isFunctionCall = false;
        private final List<String> unnamedParameters = new ArrayList<String>();
        private final Map<String, String> namedParameters = new HashMap<String, String>();
        private String assignee;
        private final Map<String, String> importingParameters = new HashMap<String, String>();
        private final Map<String, String> changingParameters = new HashMap<String, String>();
        private Pair<String, String> namedReturnParameter;
        public Map<String, String> tablesParameters = new HashMap<String, String>();
        private final Map<String, String> exceptions = new HashMap<String, String>();
        private boolean isFormCall = false;

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodContainerName() {
            return this.methodContainerName;
        }

        public boolean isStaticCall() {
            return this.isStaticCall;
        }

        public boolean isFunctionCall() {
            return this.isFunctionCall;
        }

        public void setFunctionCall(boolean isFunctionCall) {
            this.isFunctionCall = isFunctionCall;
        }

        public List<String> getUnnamedParameters() {
            return this.unnamedParameters;
        }

        public Map<String, String> getNamedParameters() {
            return this.namedParameters;
        }

        public String getAssignee() {
            return this.assignee;
        }

        public Map<String, String> getImportingParameters() {
            return this.importingParameters;
        }

        public Map<String, String> getChangingParameters() {
            return this.changingParameters;
        }

        public Pair<String, String> getNamedReturnParameter() {
            return this.namedReturnParameter;
        }

        public Map<String, String> getExceptions() {
            return this.exceptions;
        }

        public boolean isFormCall() {
            return this.isFormCall;
        }
    }

    private static class MethodCallParserException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MethodCallParserException(String message) {
            super(message);
        }
    }
}

