/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp.alignment;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.util.cpp.alignment.ContainerTypeDataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfoExtractorCoordinator;
import eu.cqse.check.framework.util.cpp.alignment.IAlignmentInfoExtractor;
import eu.cqse.check.framework.util.cpp.alignment.TypeEntityAlignmentInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class TypeEntityAlignmentInfoExtractor
implements IAlignmentInfoExtractor<TypeEntityAlignmentInfo> {
    private static final ETokenType[] ATTRIBUTE_LIST_TOKEN_TYPE_SEQUENCE = new ETokenType[]{ETokenType.ATTRIBUTE, ETokenType.LPAREN, ETokenType.LPAREN};
    private static final List<ETokenType> ALIGNED_ATTRIBUTE_TOKEN_TYPE_SEQUENCE = List.of(ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN);

    protected static ContainerTypeDataAlignmentInfo createInfo(ShallowEntity entity, int size, int alignment, List<DataAlignmentInfo> members, int padding, boolean hasPackedAttribute, boolean hasAlignmentImposedByAttribute) {
        return new ContainerTypeDataAlignmentInfo(entity.getName(), size, alignment, members, padding, hasPackedAttribute, hasAlignmentImposedByAttribute);
    }

    protected abstract ContainerTypeDataAlignmentInfo extractFromType(ShallowEntity var1, List<DataAlignmentInfo> var2, int var3, boolean var4, boolean var5);

    @Override
    public TypeEntityAlignmentInfo extract(ShallowEntity typeEntity, List<IToken> nonPreprocessedTokens, int architectureWordSizeInBytes) {
        Preconditions.checkArgument((boolean)this.isApplicable(typeEntity), (String)"Extractor is not applicable on entity: %s", (Object)typeEntity);
        List<IToken> endTokens = TypeEntityAlignmentInfoExtractor.getEndTokens(typeEntity);
        IToken lastRelevantToken = endTokens.isEmpty() ? (IToken)((UnmodifiableList)typeEntity.ownTokens().getLast()).getLast() : endTokens.getLast();
        ContainerTypeDataAlignmentInfo dataAlignmentInfo = this.extractFromType(typeEntity, nonPreprocessedTokens, architectureWordSizeInBytes);
        int numberOfDeclarations = TypeEntityAlignmentInfoExtractor.getNumberOfDeclarations(typeEntity.getName(), endTokens);
        return new TypeEntityAlignmentInfo(typeEntity, dataAlignmentInfo, numberOfDeclarations, lastRelevantToken);
    }

    private ContainerTypeDataAlignmentInfo extractFromType(ShallowEntity typeEntity, List<IToken> nonPreprocessedTokens, int architectureWordSizeInBytes) {
        List<List<IToken>> attributes = TypeEntityAlignmentInfoExtractor.getAttributes(typeEntity, nonPreprocessedTokens);
        boolean hasPackedAttribute = TypeEntityAlignmentInfoExtractor.hasPackedAttributeSet(attributes);
        Optional<Integer> alignmentImposedByAttribute = TypeEntityAlignmentInfoExtractor.getAlignmentImposedByAttribute(attributes);
        boolean hasAlignmentImposedByAttribute = alignmentImposedByAttribute.isPresent();
        List<DataAlignmentInfo> members = DataAlignmentInfoExtractorCoordinator.extract((List<ShallowEntity>)typeEntity.getChildren(), nonPreprocessedTokens, architectureWordSizeInBytes);
        if (members.isEmpty()) {
            return TypeEntityAlignmentInfoExtractor.createInfo(typeEntity, 1, alignmentImposedByAttribute.orElse(1), members, 0, hasPackedAttribute, hasAlignmentImposedByAttribute);
        }
        boolean allMembersHaveUnknownAlignment = members.stream().noneMatch(DataAlignmentInfo::hasKnownAlignment);
        if (allMembersHaveUnknownAlignment) {
            return TypeEntityAlignmentInfoExtractor.createInfo(typeEntity, -1, alignmentImposedByAttribute.orElse(-1), members, -1, hasPackedAttribute, hasAlignmentImposedByAttribute);
        }
        int alignment = hasAlignmentImposedByAttribute ? alignmentImposedByAttribute.get() : (hasPackedAttribute ? 1 : members.stream().mapToInt(DataAlignmentInfo::getAlignment).max().orElse(1));
        return this.extractFromType(typeEntity, members, alignment, hasPackedAttribute, hasAlignmentImposedByAttribute);
    }

    private static int getNumberOfDeclarations(String typeEntityName, List<IToken> endTokens) {
        boolean endTokensContainIdentifier = endTokens.stream().anyMatch(arg_0 -> ((ITokenMatcher)CppShallowParser.VALID_IDENTIFIERS).matches(arg_0));
        if (!endTokensContainIdentifier) {
            if ("<anonymous>".equals(typeEntityName)) {
                return 1;
            }
            return 0;
        }
        return 1 + TokenStreamUtils.count(endTokens, ETokenType.COMMA);
    }

    private static boolean hasPackedAttributeSet(List<List<IToken>> attributes) {
        for (List<IToken> attributeTokens : attributes) {
            IToken attributeToken;
            if (attributeTokens.size() != 1 || (attributeToken = attributeTokens.getFirst()).getType() != ETokenType.IDENTIFIER) continue;
            String attributeText = attributeToken.getText();
            if (!Set.of("packed", "__packed__").contains(attributeText)) continue;
            return true;
        }
        return false;
    }

    private static Optional<Integer> getAlignmentImposedByAttribute(List<List<IToken>> attributes) {
        for (List<IToken> attributeTokens : attributes) {
            if (!TokenStreamUtils.hasTokenTypeSequence(attributeTokens, 0, ALIGNED_ATTRIBUTE_TOKEN_TYPE_SEQUENCE) || "aligned".equals(attributeTokens.getFirst().getText())) continue;
            return Optional.of(Integer.parseInt(attributeTokens.get(2).getText()));
        }
        return Optional.empty();
    }

    private static List<List<IToken>> getAttributes(ShallowEntity typeEntity, List<IToken> nonPreprocessedTokens) {
        List<IToken> nonPreprocessedStartTokens = TypeEntityAlignmentInfoExtractor.getCorrespondingNonPreprocessedTokens((List<IToken>)typeEntity.ownStartTokens(), nonPreprocessedTokens);
        List<IToken> nonPreprocessedEndTokens = TypeEntityAlignmentInfoExtractor.getCorrespondingNonPreprocessedTokens(TypeEntityAlignmentInfoExtractor.getEndTokens(typeEntity), nonPreprocessedTokens);
        ArrayList<List<IToken>> attributes = new ArrayList<List<IToken>>();
        attributes.addAll(TypeEntityAlignmentInfoExtractor.getAttributes(nonPreprocessedStartTokens));
        attributes.addAll(TypeEntityAlignmentInfoExtractor.getAttributes(nonPreprocessedEndTokens));
        return attributes;
    }

    private static List<IToken> getCorrespondingNonPreprocessedTokens(List<IToken> preprocessedTokens, List<IToken> nonPreprocessedTokens) {
        if (preprocessedTokens.isEmpty() || nonPreprocessedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        int startOffset = preprocessedTokens.getFirst().getOffset();
        int endOffset = preprocessedTokens.getLast().getEndOffset();
        return TokenStreamUtils.getTokensBetween(nonPreprocessedTokens, startOffset, endOffset);
    }

    private static List<List<IToken>> getAttributes(List<IToken> tokens) {
        List<Integer> attributeStartIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ATTRIBUTE_LIST_TOKEN_TYPE_SEQUENCE);
        if (attributeStartIndices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<IToken>> attributes = new ArrayList<List<IToken>>();
        for (int attributeStartIndex : attributeStartIndices) {
            int attributeListStartIndex = attributeStartIndex + ATTRIBUTE_LIST_TOKEN_TYPE_SEQUENCE.length;
            int attributeListEndIndex = TokenStreamUtils.findFirstTopLevel(tokens, attributeListStartIndex, (ITokenMatcher)ETokenType.RPAREN, List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN));
            if (attributeListEndIndex == -1) continue;
            attributes.addAll(TokenStreamUtils.split(tokens.subList(attributeListStartIndex, attributeListEndIndex), ETokenType.COMMA));
        }
        return attributes;
    }

    private static List<IToken> getEndTokens(ShallowEntity typeEntity) {
        IToken typeEntityEndToken = (IToken)((UnmodifiableList)typeEntity.ownTokens().getLast()).getLast();
        if (typeEntityEndToken.getType() == ETokenType.SEMICOLON) {
            return Collections.emptyList();
        }
        List fileTokens = typeEntity.getAllTokensOfFile();
        int endTokenIndex = TokenStreamUtils.indexOfByOffset(fileTokens, typeEntityEndToken.getOffset());
        int semicolonIndex = TokenStreamUtils.firstTokenMatching(fileTokens, endTokenIndex, (ITokenMatcher)ETokenType.SEMICOLON);
        return fileTokens.subList(endTokenIndex, semicolonIndex);
    }
}

