/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cs;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cs.CsShallowParser;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CsCheckUtils {
    private static final int UNKNOWN_ARITY = -1;
    private static final String MAIN_METHOD_NAME = "Main";
    private static final String TASK_TYPE_NAME = "Task";
    private static final int REFERENCE_GROUP_INDEX = 0;
    private static final TokenPattern POSSIBLE_METHOD_REFERENCE_PATTERN = new TokenPattern().sequence(CsShallowParser.VALID_IDENTIFIERS).group(0).sequence(EnumSet.complementOf(EnumSet.of(ETokenType.LPAREN)));

    public static boolean isMainMethod(ShallowEntity method) {
        if (!MAIN_METHOD_NAME.equals(method.getName())) {
            return false;
        }
        boolean hasCorrectMainMethodArguments = CsCheckUtils.hasCorrectMainMethodArguments(method);
        if (!hasCorrectMainMethodArguments) {
            return false;
        }
        return CsCheckUtils.hasCorrectMainMethodReturnTypeAndModifiers(method);
    }

    private static boolean hasCorrectMainMethodArguments(ShallowEntity method) {
        List<List<IToken>> argumentList = CLikeCheckUtils.getMethodArguments(method, 0);
        if (argumentList.isEmpty()) {
            return true;
        }
        List<ETokenType> argTypes = argumentList.getFirst().stream().map(IToken::getType).toList();
        if (argumentList.size() == 1 && argumentList.getFirst().size() == 4) {
            List<ETokenType> validTokens = Arrays.asList(ETokenType.STRING, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.IDENTIFIER);
            return argTypes.equals(validTokens);
        }
        if (argumentList.size() == 1 && argTypes.size() == 5) {
            List<ETokenType> validTokens = Arrays.asList(ETokenType.PARAMS, ETokenType.STRING, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.IDENTIFIER);
            return argTypes.equals(validTokens);
        }
        return false;
    }

    private static boolean hasCorrectMainMethodReturnTypeAndModifiers(ShallowEntity method) {
        List<IToken> modifierReturnTokens = CLikeCheckUtils.getMethodModifiersAndReturnType(method);
        boolean isStatic = (modifierReturnTokens = modifierReturnTokens.stream().filter(token -> ETokenType.ETokenClass.KEYWORD == token.getType().getTokenClass() || ETokenType.ETokenClass.IDENTIFIER == token.getType().getTokenClass()).toList()).stream().anyMatch(token -> ETokenType.STATIC == token.getType());
        if (!isStatic) {
            return false;
        }
        HashSet<ETokenType> validModifierReturnTokens = new HashSet<ETokenType>(Arrays.asList(ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.INTERNAL, ETokenType.STATIC, ETokenType.VOID, ETokenType.INT));
        boolean hasReturnTypeTask = modifierReturnTokens.stream().anyMatch(token -> token.getType().isIdentifier() && TASK_TYPE_NAME.equals(token.getText()));
        if (hasReturnTypeTask) {
            validModifierReturnTokens.add(ETokenType.ASYNC);
        }
        return modifierReturnTokens.stream().allMatch(token -> validModifierReturnTokens.contains(token.getType()) || ETokenType.IDENTIFIER == token.getType() && TASK_TYPE_NAME.equals(token.getText()));
    }

    public static SetMap<String, Integer> retrieveMethodReferences(List<IToken> tokens) {
        SetMap result = new SetMap();
        for (TokenPatternMatch match : POSSIBLE_METHOD_REFERENCE_PATTERN.findAll(tokens)) {
            result.add((Object)match.groupString(0), (Object)-1);
        }
        return result;
    }

    public static List<IToken> extractInterpolatedCalls(List<IToken> tokens) {
        return tokens.stream().filter(token -> token.getType() == ETokenType.STRING_LITERAL || token.getType() == ETokenType.MULTILINE_COMMENT).filter(literal -> literal.getText().startsWith("$")).collect(Collectors.toList());
    }

    public static List<List<IToken>> tokenizeInterpolatedCalls(List<IToken> interpolatedStringTokens) {
        ArrayList<List<IToken>> readVariables = new ArrayList<List<IToken>>();
        for (IToken interpolatedStringToken : interpolatedStringTokens) {
            Matcher matcher = CsCheckUtils.getInterpolatedStringMatcher(interpolatedStringToken.getText());
            while (matcher.find()) {
                String interpolation = matcher.group(0);
                readVariables.add(ScannerUtils.getTokens(interpolation, ELanguage.CS, interpolatedStringToken.getOriginId()));
            }
        }
        return readVariables;
    }

    public static Matcher getInterpolatedStringMatcher(String string) {
        int numberOfDollarSigns = StringUtils.countCharacterAtStart((String)string, (char)'$');
        String pattern = "\\{*" + "\\{".repeat(numberOfDollarSigns) + "([^}]*)[^}]*" + "}".repeat(numberOfDollarSigns) + "}*";
        return Pattern.compile(pattern).matcher(string);
    }

    public static List<Integer> checkForVariableUseInStringInterpolation(List<IToken> tokens, String variableName) {
        ArrayList<Integer> uses = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("\\{(.*\\W)?" + Pattern.quote(variableName) + "(\\W.*)?\\}");
        for (int index = 0; index < tokens.size(); ++index) {
            IToken token = tokens.get(index);
            Object tokenText = token.getText();
            if (((String)tokenText).startsWith("$@\"") || ((String)tokenText).startsWith("@$\"")) {
                tokenText = "$" + ((String)tokenText).substring(2).replace("\\", "\\\\");
            }
            if (!((String)tokenText).startsWith("$\"") || !pattern.matcher((CharSequence)tokenText).find()) continue;
            uses.add(index);
        }
        return uses;
    }

    private CsCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

