/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class TokenPatternMatch {
    private final List<IToken> tokenStream;
    private final ListMap<Integer, Range> groups = new ListMap();

    public TokenPatternMatch(List<IToken> tokenStream) {
        this.tokenStream = tokenStream;
    }

    public void appendToGroup(Integer groupIndex, int inclusiveStartIndex, int exclusiveEndIndex) {
        if (inclusiveStartIndex < exclusiveEndIndex) {
            this.groups.add((Object)groupIndex, (Object)new Range(inclusiveStartIndex, exclusiveEndIndex));
        }
    }

    public List<String> groupTexts(int groupIndex) {
        return TokenStreamTextUtils.getTokenTexts(this.groupTokens(groupIndex));
    }

    public List<Integer> groupIndices(int groupIndex) {
        List ranges = (List)this.groups.getCollection((Object)groupIndex);
        if (ranges == null) {
            return CollectionUtils.emptyList();
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Range range : ranges) {
            for (int i = range.inclusiveStartIndex; i < range.exclusiveEndIndex; ++i) {
                indices.add(i);
            }
        }
        return indices;
    }

    public OptionalInt groupTokenCount(int groupIndex) {
        List ranges = (List)this.groups.getCollection((Object)groupIndex);
        if (ranges == null) {
            return OptionalInt.empty();
        }
        int tokenCount = ranges.stream().mapToInt(Range::length).sum();
        return OptionalInt.of(tokenCount);
    }

    public List<IToken> groupTokens(int groupIndex) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        for (Integer index : this.groupIndices(groupIndex)) {
            tokens.add(this.tokenStream.get(index));
        }
        return tokens;
    }

    public List<IToken> tokensBetweenGroupsExclusive(int startGroupIndex, int endGroupIndex) {
        List<IToken> startTokens = this.groupTokens(startGroupIndex);
        List<IToken> endTokens = this.groupTokens(endGroupIndex);
        if (startTokens.isEmpty() || endTokens.isEmpty()) {
            return Collections.emptyList();
        }
        return this.tokenStream.stream().filter(token -> token.getOffset() > ((IToken)startTokens.getLast()).getOffset() && token.getOffset() < ((IToken)endTokens.getFirst()).getOffset()).toList();
    }

    public List<MatchGroupElement> getMatchGroup(int groupIndex) {
        List ranges = (List)this.groups.getCollection((Object)groupIndex);
        if (ranges == null) {
            return CollectionUtils.emptyList();
        }
        ArrayList<MatchGroupElement> groupElements = new ArrayList<MatchGroupElement>();
        for (Range range : ranges) {
            groupElements.add(new MatchGroupElement(this.tokenStream.subList(range.inclusiveStartIndex, range.exclusiveEndIndex)));
        }
        return groupElements;
    }

    public String groupString(int groupIndex) {
        return StringUtils.concat(this.groupTexts(groupIndex), (String)"");
    }

    public boolean hasGroup(int groupIndex) {
        return this.groups.containsCollection((Object)groupIndex);
    }

    public void mergeFrom(TokenPatternMatch other) {
        this.groups.addAll(other.groups);
    }

    public static List<String> getAllStrings(List<TokenPatternMatch> matches, int groupIndex) {
        ArrayList<String> strings = new ArrayList<String>();
        for (TokenPatternMatch match : matches) {
            strings.add(match.groupString(groupIndex));
        }
        return strings;
    }

    public static List<IToken> getAllTokens(List<TokenPatternMatch> matches, int groupIndex) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        for (TokenPatternMatch match : matches) {
            tokens.addAll(match.groupTokens(groupIndex));
        }
        return tokens;
    }

    private static class Range {
        private final int inclusiveStartIndex;
        private final int exclusiveEndIndex;

        public Range(int inclusiveStartIndex, int exclusiveEndIndex) {
            this.inclusiveStartIndex = inclusiveStartIndex;
            this.exclusiveEndIndex = exclusiveEndIndex;
        }

        public int length() {
            return this.exclusiveEndIndex - this.inclusiveStartIndex;
        }
    }
}

