/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class WiaTokenUtils {
    private static final int DEFAULT_GROUP = 0;
    private static final TokenPattern INTERNAL_ID_PATTERN = new TokenPattern().regex("^id$").sequence(ETokenType.DOT).regex("^internalId$").sequence(ETokenType.EQ).sequence(ETokenType.STRING_LITERAL).group(0);
    private static final TokenPattern IS_CLOSED_PATTERN = new TokenPattern().regex("^closed$").sequence(ETokenType.EQ).sequence(ETokenType.BOOLEAN_LITERAL).group(0);

    public static String removeStringQuotes(String text) {
        if (!(text.length() < 2 || text.charAt(0) != '\'' && text.charAt(0) != '\"' || text.charAt(text.length() - 1) != '\'' && text.charAt(text.length() - 1) != '\"')) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static Optional<String> getInternalId(List<IToken> tokens) {
        TokenPatternMatch match = INTERNAL_ID_PATTERN.findFirstMatch(tokens);
        if (match == null) {
            return Optional.empty();
        }
        String tokenText = match.groupString(0);
        return Optional.of(WiaTokenUtils.removeStringQuotes(tokenText));
    }

    public static Optional<Boolean> isItemClosed(List<IToken> tokens) {
        TokenPatternMatch match = IS_CLOSED_PATTERN.findFirstMatch(tokens);
        if (match == null) {
            return Optional.empty();
        }
        String tokenText = match.groupString(0);
        return Optional.of(Boolean.valueOf(tokenText));
    }

    public static String translateTomlEscapes(String string) {
        if (string.isEmpty()) {
            return "";
        }
        char[] chars = string.toCharArray();
        int length = chars.length;
        int from = 0;
        int to = 0;
        while (from < length) {
            char ch;
            if ((ch = chars[from++]) == '\\') {
                if (from >= length) {
                    throw new IllegalArgumentException("Unfinished escape sequence at the end of string");
                }
                Pair<Integer, char[]> unescaped = WiaTokenUtils.unescapeTomlChar(chars, from);
                from = (Integer)unescaped.getFirst();
                for (char c : (char[])unescaped.getSecond()) {
                    chars[to++] = c;
                }
                continue;
            }
            chars[to++] = ch;
        }
        return new String(chars, 0, to);
    }

    private static Pair<Integer, char[]> unescapeTomlChar(char[] chars, int startIndex) {
        char ch = chars[startIndex++];
        switch (ch) {
            case 'b': {
                ch = '\b';
                break;
            }
            case 't': {
                ch = '\t';
                break;
            }
            case 'n': {
                ch = '\n';
                break;
            }
            case 'f': {
                ch = '\f';
                break;
            }
            case 'r': {
                ch = '\r';
                break;
            }
            case '\"': 
            case '\\': {
                break;
            }
            case 'u': {
                return WiaTokenUtils.unescapeTomlUnicode(chars, startIndex, 4);
            }
            case 'U': {
                return WiaTokenUtils.unescapeTomlUnicode(chars, startIndex, 8);
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid escape sequence: \\%c \\\\u%04X", Character.valueOf(ch), (int)ch));
            }
        }
        return new Pair((Object)startIndex, (Object)new char[]{ch});
    }

    private static Pair<Integer, char[]> unescapeTomlUnicode(char[] chars, int startIndex, int maxCharCount) {
        int limit = Integer.min(startIndex + maxCharCount, chars.length);
        StringBuilder unicodeHex = new StringBuilder(maxCharCount);
        while (startIndex < limit) {
            char aChar;
            if (WiaTokenUtils.isHex(aChar = chars[startIndex++])) {
                unicodeHex.append(aChar);
                continue;
            }
            --startIndex;
            break;
        }
        try {
            int codePoint = Integer.parseInt(unicodeHex.toString(), 16);
            return new Pair((Object)startIndex, (Object)Character.toChars(codePoint));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unable to parse unicode value: " + String.valueOf(unicodeHex), nfe);
        }
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private WiaTokenUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

