/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class StaticMethodCallRecognizer {
    private static final EnumSet<ETokenType> METHOD_CALL_TOKEN_TYPES = EnumSet.of(ETokenType.DOT, ETokenType.SCOPE, ETokenType.POINTERTO);
    private final String fullQualifiedName;
    private String[] recognitionSequence;

    public StaticMethodCallRecognizer(String fullQualifiedMethodName) {
        CCSMAssert.isNotNull((Object)fullQualifiedMethodName);
        this.fullQualifiedName = fullQualifiedMethodName;
        this.initializeRecognitionSequence();
    }

    private void initializeRecognitionSequence() {
        List splitTokens = StringUtils.splitKeepingSeparators((String)this.fullQualifiedName, (String[])new String[]{".", "::"});
        splitTokens.add("(");
        this.recognitionSequence = splitTokens.toArray(new String[0]);
    }

    public List<Integer> findCallsInTokens(List<IToken> tokens) {
        List<Integer> potentialCalls = TokenStreamTextUtils.findAllSequences(tokens, 0, ETokenType.IDENTIFIER, this.recognitionSequence);
        return CollectionUtils.filter(potentialCalls, index -> StaticMethodCallRecognizer.atBeginningOrNotPreceededByMethodCallSeparator(tokens, index));
    }

    private static boolean atBeginningOrNotPreceededByMethodCallSeparator(List<IToken> tokens, int index) {
        if (index == 0) {
            return true;
        }
        ETokenType previousType = tokens.get(index - 1).getType();
        return !METHOD_CALL_TOKEN_TYPES.contains(previousType) && previousType != ETokenType.IDENTIFIER;
    }

    public int getTokenLength() {
        return this.recognitionSequence.length - 1;
    }

    public String getFullQualifiedMethodName() {
        return this.fullQualifiedName;
    }
}

