/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies;

import com.microsoft.tfs.core.checkinpolicies.PolicyInstance;
import com.microsoft.tfs.core.checkinpolicies.PolicySerializationException;
import com.microsoft.tfs.core.checkinpolicies.PolicyType;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.memento.XMLMemento;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;

public class PolicyDefinition {
    public static final int SUPPORTED_VERSION = 1;
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String ENABLED_ATTRIBUTE_NAME = "enabled";
    private static final String PRIORITY_ATTRIBUTE_NAME = "priority";
    private static final String SCOPE_EXPRESSION_MEMENTO_NAME = "scope";
    private static final String POLICY_TYPE_MEMENTO_NAME = "policy-type";
    private static final String POLICY_TYPE_ID_ATTRIBUTE_NAME = "id";
    private static final String POLICY_TYPE_NAME_ATTRIBUTE_NAME = "name";
    private static final String POLICY_TYPE_SHORT_DESCRIPTION_ATTRIBUTE_NAME = "short-description";
    private static final String POLICY_TYPE_LONG_DESCRIPTION_ATTRIBUTE_NAME = "long-description";
    private static final String POLICY_TYPE_INSTALLATION_INSTRUCTIONS_ATTRIBUTE_NAME = "installation-instructions";
    private static final String CONFIGURATION_DATA_MEMENTO_NAME = "configuration-data";
    private final PolicyType type;
    private final Memento configurationMemento;
    private final boolean enabled;
    private final int priority;
    private final String[] scopeExpressions;

    public PolicyDefinition(PolicyType type, Memento configurationMemento, boolean enabled, int priority, String[] scopeExpressions) {
        Check.notNull(type, "type");
        Check.notNull(configurationMemento, "configurationMemento");
        Check.notNull(scopeExpressions, "scopeExpressions");
        this.type = type;
        this.configurationMemento = configurationMemento;
        this.enabled = enabled;
        this.priority = priority;
        this.scopeExpressions = scopeExpressions;
    }

    public PolicyDefinition(PolicyInstance instance, boolean enabled, int priority, String[] scopeExpressions) {
        Check.notNull(instance, "instance");
        this.type = instance.getPolicyType();
        this.configurationMemento = new XMLMemento(CONFIGURATION_DATA_MEMENTO_NAME);
        instance.saveConfiguration(this.configurationMemento);
        this.enabled = enabled;
        this.priority = priority;
        this.scopeExpressions = scopeExpressions;
    }

    public static PolicyDefinition fromMemento(Memento definitionMemento) throws PolicySerializationException {
        Boolean enabled;
        Check.notNull(definitionMemento, "definitionMemento");
        Integer schemaVersion = definitionMemento.getInteger(VERSION_ATTRIBUTE_NAME);
        if (schemaVersion == null) {
            throw new PolicySerializationException("The policy definition did not specify a schema version");
        }
        if (schemaVersion != 1) {
            throw new PolicySerializationException(MessageFormat.format("Policy definition data version {0} can not be read by this definition serializer.", schemaVersion.toString()));
        }
        Integer priority = definitionMemento.getInteger(PRIORITY_ATTRIBUTE_NAME);
        if (priority == null) {
            priority = new Integer(0);
        }
        if ((enabled = definitionMemento.getBoolean(ENABLED_ATTRIBUTE_NAME)) == null) {
            enabled = Boolean.TRUE;
        }
        ArrayList<String> expressions = new ArrayList<String>();
        Memento[] scopeChildren = definitionMemento.getChildren(SCOPE_EXPRESSION_MEMENTO_NAME);
        for (int i = 0; i < scopeChildren.length; ++i) {
            Memento m = scopeChildren[i];
            if (m == null || m.getTextData() == null || m.getTextData().length() <= 0) continue;
            expressions.add(m.getTextData());
        }
        String[] scopeExpressions = expressions.toArray(new String[expressions.size()]);
        Memento policyTypeMemento = definitionMemento.getChild(POLICY_TYPE_MEMENTO_NAME);
        if (policyTypeMemento == null) {
            throw new PolicySerializationException(MessageFormat.format("Could not find the {0} memento", POLICY_TYPE_MEMENTO_NAME));
        }
        String id = policyTypeMemento.getString(POLICY_TYPE_ID_ATTRIBUTE_NAME);
        String name = policyTypeMemento.getString(POLICY_TYPE_NAME_ATTRIBUTE_NAME);
        String shortDescription = policyTypeMemento.getString(POLICY_TYPE_SHORT_DESCRIPTION_ATTRIBUTE_NAME);
        String longDescription = policyTypeMemento.getString(POLICY_TYPE_LONG_DESCRIPTION_ATTRIBUTE_NAME);
        String installationInstructions = policyTypeMemento.getString(POLICY_TYPE_INSTALLATION_INSTRUCTIONS_ATTRIBUTE_NAME);
        if (id == null || id.length() == 0) {
            throw new PolicySerializationException("Policy had a null or empty id");
        }
        if (name == null || name.length() == 0) {
            throw new PolicySerializationException("Policy had a null or empty name");
        }
        if (shortDescription == null) {
            throw new PolicySerializationException("Policy had a null or empty short description");
        }
        if (longDescription == null) {
            throw new PolicySerializationException("Policy had a null or empty long description");
        }
        Memento configurationMemento = definitionMemento.getChild(CONFIGURATION_DATA_MEMENTO_NAME);
        if (configurationMemento == null) {
            throw new PolicySerializationException(MessageFormat.format("Could not find the {0} memento", CONFIGURATION_DATA_MEMENTO_NAME));
        }
        return new PolicyDefinition(new PolicyType(id, name, shortDescription, longDescription, installationInstructions), configurationMemento, enabled, priority, scopeExpressions);
    }

    public void toMemento(Memento definitionMemento) {
        Check.notNull(definitionMemento, "definitionMemento");
        definitionMemento.putInteger(VERSION_ATTRIBUTE_NAME, 1);
        definitionMemento.putInteger(PRIORITY_ATTRIBUTE_NAME, this.getPriority());
        definitionMemento.putBoolean(ENABLED_ATTRIBUTE_NAME, this.isEnabled());
        for (int i = 0; i < this.scopeExpressions.length; ++i) {
            String expression = this.scopeExpressions[i];
            if (expression == null || expression.length() <= 0) continue;
            Memento scopeMemento = definitionMemento.createChild(SCOPE_EXPRESSION_MEMENTO_NAME);
            scopeMemento.putTextData(expression);
        }
        Memento policyTypeMemento = definitionMemento.createChild(POLICY_TYPE_MEMENTO_NAME);
        policyTypeMemento.putString(POLICY_TYPE_ID_ATTRIBUTE_NAME, this.type.getID());
        policyTypeMemento.putString(POLICY_TYPE_NAME_ATTRIBUTE_NAME, this.type.getName());
        policyTypeMemento.putString(POLICY_TYPE_SHORT_DESCRIPTION_ATTRIBUTE_NAME, this.type.getShortDescription());
        policyTypeMemento.putString(POLICY_TYPE_LONG_DESCRIPTION_ATTRIBUTE_NAME, this.type.getLongDescription());
        policyTypeMemento.putString(POLICY_TYPE_INSTALLATION_INSTRUCTIONS_ATTRIBUTE_NAME, this.type.getInstallationInstructions());
        Memento configurationMemento = definitionMemento.createChild(CONFIGURATION_DATA_MEMENTO_NAME);
        configurationMemento.putMemento(this.configurationMemento);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public PolicyType getType() {
        return this.type;
    }

    public String[] getScopeExpressions() {
        return this.scopeExpressions;
    }

    public Memento getConfigurationMemento() {
        return this.configurationMemento;
    }
}

