/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.IBuildAgentQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildAgentSpec;
import com.microsoft.tfs.core.clients.build.IBuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildControllerSpec;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import ms.tfs.build.buildservice._04._AdministrationServiceSoap;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._BuildAgentQueryResult;
import ms.tfs.build.buildservice._04._BuildAgentSpec;
import ms.tfs.build.buildservice._04._BuildAgentUpdateOptions;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._BuildControllerQueryResult;
import ms.tfs.build.buildservice._04._BuildControllerSpec;
import ms.tfs.build.buildservice._04._BuildControllerUpdateOptions;
import ms.tfs.build.buildservice._04._BuildServiceHost;
import ms.tfs.build.buildservice._04._BuildServiceHostQueryResult;

public class AdministrationWebService4 {
    private final _AdministrationServiceSoap webService;
    private final IBuildServer buildServer;

    public AdministrationWebService4(TFSTeamProjectCollection tfs) {
        this.webService = (_AdministrationServiceSoap)tfs.getWebService(_AdministrationServiceSoap.class);
        this.buildServer = tfs.getBuildServer();
    }

    public void deleteBuildServiceHost(String serviceHostUri) {
        this.webService.deleteBuildServiceHost(serviceHostUri);
    }

    public BuildServiceHostQueryResult queryBuildServiceHosts(String computer) {
        _BuildServiceHostQueryResult _result = this.webService.queryBuildServiceHosts(computer);
        return new BuildServiceHostQueryResult(this.buildServer, _result);
    }

    public BuildServiceHostQueryResult queryBuildServiceHostsByUri(String[] serviceHostUris) {
        _BuildServiceHostQueryResult _result = this.webService.queryBuildServiceHostsByUri(serviceHostUris);
        return new BuildServiceHostQueryResult(this.buildServer, _result);
    }

    public BuildServiceHost addBuildServiceHost(BuildServiceHost serviceHost) {
        _BuildServiceHost _result = this.webService.addBuildServiceHost(serviceHost.getWebServiceObject());
        return new BuildServiceHost(this.buildServer, _result);
    }

    public void updateBuildServiceHost(BuildServiceHostUpdateOptions update) {
        this.webService.updateBuildServiceHost(update.getWebServiceObject());
    }

    public IBuildAgentQueryResult queryBuildAgentsByUri(String[] agentUris, String[] propertyNameFilters) {
        _BuildAgentQueryResult _result = this.webService.queryBuildAgentsByUri(agentUris, propertyNameFilters);
        return new BuildAgentQueryResult(this.buildServer, _result);
    }

    public IBuildAgentQueryResult[] queryBuildAgents(IBuildAgentSpec[] buildAgentSpecs) {
        _BuildAgentSpec[] _specs = (_BuildAgentSpec[])WrapperUtils.unwrap(_BuildAgentSpec.class, buildAgentSpecs);
        _BuildAgentQueryResult[] _results = this.webService.queryBuildAgents(_specs);
        return BuildTypeConvertor.toBuildAgentQueryResultArray(this.buildServer, _results);
    }

    public void deleteBuildAgents(String[] agentUris) {
        this.webService.deleteBuildAgents(agentUris);
    }

    public BuildAgent[] addBuildAgents(BuildAgent[] addRequests) {
        _BuildAgent[] _agents = (_BuildAgent[])WrapperUtils.unwrap(_BuildAgent.class, addRequests);
        _BuildAgent[] _results = this.webService.addBuildAgents(_agents);
        return BuildTypeConvertor.toBuildAgentArray(_results);
    }

    public void updateBuildAgents(BuildAgentUpdateOptions[] updateOptions) {
        _BuildAgentUpdateOptions[] _updates = (_BuildAgentUpdateOptions[])WrapperUtils.unwrap(_BuildAgentUpdateOptions.class, updateOptions);
        this.webService.updateBuildAgents(_updates);
    }

    public IBuildControllerQueryResult queryBuildControllersByUri(String[] controllerUris, String[] propertyNameFilters, boolean includeAgents) {
        _BuildControllerQueryResult _result = this.webService.queryBuildControllersByUri(controllerUris, propertyNameFilters, includeAgents);
        return new BuildControllerQueryResult(this.buildServer, _result);
    }

    public IBuildControllerQueryResult[] queryBuildControllers(IBuildControllerSpec[] controllerSpecs) {
        _BuildControllerSpec[] _specs = (_BuildControllerSpec[])WrapperUtils.unwrap(_BuildControllerSpec.class, controllerSpecs);
        _BuildControllerQueryResult[] _results = this.webService.queryBuildControllers(_specs);
        return BuildTypeConvertor.toBuildControllerQueryResultArray(this.buildServer, _results);
    }

    public void deleteBuildControllers(String[] controllerUris) {
        this.webService.deleteBuildControllers(controllerUris);
    }

    public BuildController[] addBuildControllers(BuildController[] addRequests) {
        _BuildController[] _controllers = (_BuildController[])WrapperUtils.unwrap(_BuildController.class, addRequests);
        _BuildController[] _results = this.webService.addBuildControllers(_controllers);
        return BuildTypeConvertor.toBuildControllersArray(this.buildServer, _results);
    }

    public void updateBuildControllers(BuildControllerUpdateOptions[] updateOptions) {
        _BuildControllerUpdateOptions[] _updates = (_BuildControllerUpdateOptions[])WrapperUtils.unwrap(_BuildControllerUpdateOptions.class, updateOptions);
        this.webService.updateBuildControllers(_updates);
    }
}

