/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.clients.build.internal.utils.QueryResultHelper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import java.util.HashMap;
import java.util.Map;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._BuildDefinition;
import ms.tfs.build.buildservice._04._BuildQueryResult;
import ms.tfs.build.buildservice._04._BuildServiceHost;
import ms.tfs.build.buildservice._04._QueuedBuild;

public class BuildQueryResult
extends WebServiceObjectWrapper
implements IBuildQueryResult {
    private final BuildServiceHost[] serviceHosts;
    private final BuildController[] controllers;
    private final BuildAgent[] agents;
    private final BuildDefinition[] definitions;
    private final QueuedBuild[] queuedBuilds;
    private final BuildDetail[] builds;

    public BuildQueryResult(IBuildServer buildServer, _BuildQueryResult webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.serviceHosts = BuildTypeConvertor.toBuildServiceHostArray(buildServer, this.getWebServiceObject().getServiceHosts());
        this.controllers = BuildTypeConvertor.toBuildControllersArray(buildServer, this.getWebServiceObject().getControllers());
        this.agents = BuildTypeConvertor.toBuildAgentArray(this.getWebServiceObject().getAgents());
        this.definitions = BuildTypeConvertor.toBuildDefinitionArray(buildServer, this.getWebServiceObject().getDefinitions());
        this.queuedBuilds = BuildTypeConvertor.toQueuedBuildArray(buildServer, this.getWebServiceObject().getQueuedBuilds());
        this.builds = BuildTypeConvertor.toBuildDetailArray(buildServer, this.getWebServiceObject().getBuilds());
        this.afterDeserialize(buildServer);
    }

    public BuildQueryResult(IBuildServer buildServer, BuildAgent[] agents, BuildController[] controllers, BuildDefinition[] definitions, BuildDetail[] builds, BuildServiceHost[] serviceHosts) {
        super(new _BuildQueryResult());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(agents, "agents");
        Check.notNull(controllers, "controllers");
        Check.notNull(definitions, "definitions");
        Check.notNull(builds, "builds");
        Check.notNull(serviceHosts, "serviceHosts");
        this.agents = agents;
        this.controllers = controllers;
        this.definitions = definitions;
        this.builds = builds;
        this.serviceHosts = serviceHosts;
        this.queuedBuilds = new QueuedBuild[0];
        _BuildAgent[] _agents = (_BuildAgent[])WrapperUtils.unwrap(_BuildAgent.class, agents);
        _BuildController[] _controllers = (_BuildController[])WrapperUtils.unwrap(_BuildController.class, controllers);
        _BuildDefinition[] _definitions = (_BuildDefinition[])WrapperUtils.unwrap(_BuildDefinition.class, definitions);
        _QueuedBuild[] _queuedBuilds = (_QueuedBuild[])WrapperUtils.unwrap(_QueuedBuild.class, this.queuedBuilds);
        _BuildServiceHost[] _serviceHosts = (_BuildServiceHost[])WrapperUtils.unwrap(_BuildServiceHost.class, serviceHosts);
        this.getWebServiceObject().setAgents(_agents);
        this.getWebServiceObject().setControllers(_controllers);
        this.getWebServiceObject().setDefinitions(_definitions);
        this.getWebServiceObject().setQueuedBuilds(_queuedBuilds);
        this.getWebServiceObject().setServiceHosts(_serviceHosts);
        this.afterDeserialize(buildServer);
    }

    public _BuildQueryResult getWebServiceObject() {
        return (_BuildQueryResult)this.webServiceObject;
    }

    @Override
    public IBuildDetail[] getBuilds() {
        return this.builds;
    }

    @Override
    public IFailure[] getFailures() {
        return new IFailure[0];
    }

    private void afterDeserialize(IBuildServer buildServer) {
        BuildDefinition definition;
        BuildController controller;
        Map<String, BuildController> controllerMap = QueryResultHelper.match(this.serviceHosts, this.controllers, this.agents);
        HashMap<String, BuildDefinition> definitionMap = new HashMap<String, BuildDefinition>();
        for (BuildDefinition definition2 : this.definitions) {
            definitionMap.put(definition2.getURI(), definition2);
            BuildController buildController = controllerMap.get(definition2.getBuildControllerURI());
            if (buildController == null) continue;
            definition2.setBuildController(buildController);
        }
        HashMap<Integer, QueuedBuild> buildMap = new HashMap<Integer, QueuedBuild>();
        for (QueuedBuild queuedBuild : this.queuedBuilds) {
            buildMap.put(queuedBuild.getID(), queuedBuild);
            controller = controllerMap.get(queuedBuild.getBuildControllerURI());
            if (controller != null) {
                queuedBuild.setBuildController(controller);
            }
            if ((definition = (BuildDefinition)definitionMap.get(queuedBuild.getBuildDefinitionURI())) == null) continue;
            queuedBuild.setBuildDefinition(definition);
        }
        for (WebServiceObjectWrapper webServiceObjectWrapper : this.builds) {
            if (webServiceObjectWrapper == null) continue;
            controller = controllerMap.get(((BuildDetail)webServiceObjectWrapper).getBuildControllerURI());
            if (controller != null) {
                ((BuildDetail)webServiceObjectWrapper).setBuildController(controller);
            }
            if ((definition = (BuildDefinition)definitionMap.get(((BuildDetail)webServiceObjectWrapper).getBuildDefinitionURI())) != null) {
                ((BuildDetail)webServiceObjectWrapper).setBuildDefinition(definition);
            }
            for (BuildInformationNode informationNode : ((BuildDetail)webServiceObjectWrapper).getInternalInformation()) {
                informationNode.setBuild((BuildDetail)webServiceObjectWrapper);
            }
            for (int queueId : ((BuildDetail)webServiceObjectWrapper).getRequestIDs()) {
                QueuedBuild queuedBuild = (QueuedBuild)buildMap.get(queueId);
                if (queuedBuild == null) continue;
                ((BuildDetail)webServiceObjectWrapper).addRequest(queuedBuild);
                queuedBuild.getAllBuilds().add((IBuildDetail)((Object)webServiceObjectWrapper));
            }
        }
    }
}

