/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.soapextensions;

import com.microsoft.tfs.core.internal.wrappers.EnumerationWrapper;
import com.microsoft.tfs.util.Check;
import ms.tfs.build.buildservice._04._QueuePriority;

public class QueuePriority
extends EnumerationWrapper
implements Comparable<QueuePriority> {
    public static final QueuePriority LOW = new QueuePriority(_QueuePriority.Low, "Low");
    public static final QueuePriority BELOW_NORMAL = new QueuePriority(_QueuePriority.BelowNormal, "Below Normal");
    public static final QueuePriority NORMAL = new QueuePriority(_QueuePriority.Normal, "Normal");
    public static final QueuePriority ABOVE_NORMAL = new QueuePriority(_QueuePriority.AboveNormal, "Above Normal");
    public static final QueuePriority HIGH = new QueuePriority(_QueuePriority.High, "High");
    private final String displayText;

    private QueuePriority(_QueuePriority queuePriority, String displayText) {
        super(queuePriority);
        this.displayText = displayText;
    }

    public static QueuePriority fromWebServiceObject(_QueuePriority webServiceObject) {
        if (webServiceObject == null) {
            return null;
        }
        return (QueuePriority)EnumerationWrapper.fromWebServiceObject(webServiceObject);
    }

    public _QueuePriority getWebServiceObject() {
        return (_QueuePriority)this.webServiceObject;
    }

    public static QueuePriority fromDisplayText(String displayText) {
        Check.notNull(displayText, "displayText");
        if (LOW.getDisplayText().equals(displayText)) {
            return LOW;
        }
        if (BELOW_NORMAL.getDisplayText().equals(displayText)) {
            return BELOW_NORMAL;
        }
        if (ABOVE_NORMAL.getDisplayText().equals(displayText)) {
            return ABOVE_NORMAL;
        }
        if (HIGH.getDisplayText().equals(displayText)) {
            return HIGH;
        }
        return NORMAL;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    @Override
    public int compareTo(QueuePriority other) {
        return this.getSortPosition(this) - this.getSortPosition(other);
    }

    private int getSortPosition(QueuePriority priority) {
        if (priority == HIGH) {
            return 1;
        }
        if (priority == ABOVE_NORMAL) {
            return 2;
        }
        if (priority == NORMAL) {
            return 3;
        }
        if (priority == BELOW_NORMAL) {
            return 4;
        }
        if (priority == LOW) {
            return 5;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

