/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.registration.internal;

import com.microsoft.tfs.core.clients.registration.ServerMap;
import com.microsoft.tfs.core.internal.persistence.DOMObjectSerializer;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.text.MessageFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerMapSerializer
extends DOMObjectSerializer {
    private static final int SCHEMA_VERSION = 1;
    private static final String SERVERS_ELEMENT_NAME = "servers";
    private static final String SERVER_ELEMENT_NAME = "server";
    private static final String URI_ELEMENT_NAME = "uri";
    private static final String ID_ELEMENT_NAME = "id";
    private static final String VERSION_ATTRIBUTE_NAME = "version";

    @Override
    protected Document createDocumentFromComponent(Object object) {
        ServerMap serverMap = (ServerMap)object;
        Document document = DOMCreateUtils.newDocument(SERVERS_ELEMENT_NAME);
        Element rootElement = document.getDocumentElement();
        rootElement.setAttribute(VERSION_ATTRIBUTE_NAME, String.valueOf(1));
        String[] uris = serverMap.getURIs();
        for (int i = 0; i < uris.length; ++i) {
            String id = serverMap.getServerID(uris[i]);
            this.serializeServerData(uris[i], id, document, rootElement);
        }
        return document;
    }

    private void serializeServerData(String uri, String id, Document document, Element parentElement) {
        Element serverElement = DOMUtils.appendChild(parentElement, SERVER_ELEMENT_NAME);
        DOMUtils.appendChildWithText(serverElement, URI_ELEMENT_NAME, uri);
        DOMUtils.appendChildWithText(serverElement, ID_ELEMENT_NAME, id);
    }

    @Override
    protected Object createComponentFromDocument(Document document) {
        Element root = document.getDocumentElement();
        if (!SERVERS_ELEMENT_NAME.equals(root.getNodeName())) {
            throw new RuntimeException(MessageFormat.format("unexpected root element: {0}", root.getNodeName()));
        }
        int schemaVersion = -1;
        String sSchemaVersion = root.getAttribute(VERSION_ATTRIBUTE_NAME);
        if (sSchemaVersion != null && sSchemaVersion.length() > 0) {
            try {
                schemaVersion = Integer.parseInt(sSchemaVersion);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        ServerMap serverMap = new ServerMap();
        Element[] serverElements = DOMUtils.getChildElements(root, SERVER_ELEMENT_NAME);
        for (int i = 0; i < serverElements.length; ++i) {
            this.deserializeServerData(serverElements[i], serverMap, schemaVersion);
        }
        return serverMap;
    }

    private void deserializeServerData(Element serverElement, ServerMap serverMap, int schemaVersion) {
        Element uriElement = DOMUtils.getFirstChildElement(serverElement, URI_ELEMENT_NAME);
        if (uriElement == null) {
            return;
        }
        String uri = DOMUtils.getText(uriElement);
        if (uri == null || uri.trim().length() == 0) {
            return;
        }
        uri = uri.trim();
        Element idElement = DOMUtils.getFirstChildElement(serverElement, ID_ELEMENT_NAME);
        if (idElement == null) {
            return;
        }
        String id = DOMUtils.getText(idElement);
        if (id == null || id.trim().length() == 0) {
            return;
        }
        serverMap.addServerID(uri, id);
    }
}

